/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.keycloak.VerificationException;
import org.keycloak.models.ClientModel;
import org.keycloak.util.PemUtils;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.w3c.dom.Document;

public class SamlProtocolUtils {
    public static void verifyDocumentSignature(ClientModel client, Document document) throws VerificationException {
        if (!"true".equals(client.getAttribute("saml.client.signature"))) {
            return;
        }
        SAML2Signature saml2Signature = new SAML2Signature();
        PublicKey publicKey = SamlProtocolUtils.getSignatureValidationKey(client);
        try {
            if (!saml2Signature.validate(document, publicKey)) {
                throw new VerificationException("Invalid signature on document");
            }
        }
        catch (ProcessingException e) {
            throw new VerificationException("Error validating signature", (Throwable)e);
        }
    }

    public static PublicKey getSignatureValidationKey(ClientModel client) throws VerificationException {
        return SamlProtocolUtils.getPublicKey(client, "saml.signing.certificate");
    }

    public static PublicKey getEncryptionValidationKey(ClientModel client) throws VerificationException {
        return SamlProtocolUtils.getPublicKey(client, "saml.encryption.certificate");
    }

    public static PublicKey getPublicKey(ClientModel client, String attribute) throws VerificationException {
        String certPem = client.getAttribute(attribute);
        if (certPem == null) {
            throw new VerificationException("Client does not have a public key.");
        }
        X509Certificate cert = null;
        try {
            cert = PemUtils.decodeCertificate((String)certPem);
        }
        catch (Exception e) {
            throw new VerificationException("Could not decode cert", (Throwable)e);
        }
        return cert.getPublicKey();
    }
}

