/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Document;

public class SAML2LogoutRequestBuilder
implements SamlProtocolExtensionsAwareBuilder<SAML2LogoutRequestBuilder> {
    protected NameIDType nameId;
    protected String sessionIndex;
    protected long assertionExpiration;
    protected String destination;
    protected String issuer;
    protected final List<SamlProtocolExtensionsAwareBuilder.NodeGenerator> extensions = new LinkedList<SamlProtocolExtensionsAwareBuilder.NodeGenerator>();

    public SAML2LogoutRequestBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public SAML2LogoutRequestBuilder issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Override
    public SAML2LogoutRequestBuilder addExtension(SamlProtocolExtensionsAwareBuilder.NodeGenerator extension) {
        this.extensions.add(extension);
        return this;
    }

    public SAML2LogoutRequestBuilder assertionExpiration(int assertionExpiration) {
        this.assertionExpiration = assertionExpiration;
        return this;
    }

    @Deprecated
    public SAML2LogoutRequestBuilder userPrincipal(String userPrincipal, String userPrincipalFormat) {
        NameIDType nid = new NameIDType();
        nid.setValue(userPrincipal);
        if (userPrincipalFormat != null) {
            nid.setFormat(URI.create(userPrincipalFormat));
        }
        return this.nameId(nid);
    }

    public SAML2LogoutRequestBuilder nameId(NameIDType nameId) {
        this.nameId = nameId;
        return this;
    }

    public SAML2LogoutRequestBuilder sessionIndex(String index) {
        this.sessionIndex = index;
        return this;
    }

    public Document buildDocument() throws ProcessingException, ConfigurationException, ParsingException {
        Document document = SAML2Request.convert((RequestAbstractType)this.createLogoutRequest());
        return document;
    }

    public LogoutRequestType createLogoutRequest() throws ConfigurationException {
        LogoutRequestType lort = SAML2Request.createLogoutRequest(this.issuer);
        lort.setNameID(this.nameId);
        if (this.issuer != null) {
            NameIDType issuerID = new NameIDType();
            issuerID.setValue(this.issuer);
            lort.setIssuer(issuerID);
        }
        if (this.sessionIndex != null) {
            lort.addSessionIndex(this.sessionIndex);
        }
        if (this.assertionExpiration > 0L) {
            lort.setNotOnOrAfter(XMLTimeUtil.add(lort.getIssueInstant(), this.assertionExpiration * 1000L));
        }
        if (this.destination != null) {
            lort.setDestination(URI.create(this.destination));
        }
        if (!this.extensions.isEmpty()) {
            ExtensionsType extensionsType = new ExtensionsType();
            for (SamlProtocolExtensionsAwareBuilder.NodeGenerator extension : this.extensions) {
                extensionsType.addExtension((Object)extension);
            }
            lort.setExtensions(extensionsType);
        }
        return lort;
    }
}

