/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.EncryptedAssertionType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLStatusResponseTypeParser;
import org.w3c.dom.Element;

public class SAMLResponseParser
extends SAMLStatusResponseTypeParser
implements ParserNamespaceSupport {
    private final String RESPONSE = JBossSAMLConstants.RESPONSE.get();

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, this.RESPONSE);
        ResponseType response = (ResponseType)this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.ISSUER.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                NameIDType issuer = new NameIDType();
                issuer.setValue(StaxParserUtil.getElementText(xmlEventReader));
                response.setIssuer(issuer);
                continue;
            }
            if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
                Element sig = StaxParserUtil.getDOMElement(xmlEventReader);
                response.setSignature(sig);
                continue;
            }
            if (JBossSAMLConstants.ASSERTION.get().equals(elementName)) {
                SAMLAssertionParser assertionParser = new SAMLAssertionParser();
                response.addAssertion(new ResponseType.RTChoiceType((AssertionType)assertionParser.parse(xmlEventReader)));
                continue;
            }
            if (JBossSAMLConstants.STATUS.get().equals(elementName)) {
                response.setStatus(this.parseStatus(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ENCRYPTED_ASSERTION.get().equals(elementName)) {
                Element encryptedAssertion = StaxParserUtil.getDOMElement(xmlEventReader);
                response.addAssertion(new ResponseType.RTChoiceType(new EncryptedAssertionType(encryptedAssertion)));
                continue;
            }
            throw logger.parserUnknownTag(elementName, startElement.getLocation());
        }
        return response;
    }

    @Override
    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI()) && this.RESPONSE.equals(qname.getLocalPart());
    }

    @Override
    protected StatusResponseType parseBaseAttributes(StartElement startElement) throws ParsingException {
        ResponseType response = new ResponseType(super.parseBaseAttributes(startElement));
        return response;
    }
}

