/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.dom.saml.v1.assertion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.dom.saml.common.CommonAssertionType;
import org.keycloak.dom.saml.v1.assertion.SAML11AdviceType;
import org.keycloak.dom.saml.v1.assertion.SAML11ConditionsType;
import org.keycloak.dom.saml.v1.assertion.SAML11StatementAbstractType;
import org.w3c.dom.Element;

public class SAML11AssertionType
extends CommonAssertionType {
    private static final long serialVersionUID = 1L;
    protected int majorVersion = 1;
    protected int minorVersion = 1;
    protected SAML11ConditionsType conditions;
    protected SAML11AdviceType advice;
    protected List<SAML11StatementAbstractType> statements = new ArrayList<SAML11StatementAbstractType>();
    protected Element signature;
    protected String issuer;

    public SAML11AssertionType(String iD, XMLGregorianCalendar issueInstant) {
        super(iD, issueInstant);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void add(SAML11StatementAbstractType statement) {
        this.statements.add(statement);
    }

    public void addAllStatements(List<SAML11StatementAbstractType> statement) {
        this.statements.addAll(statement);
    }

    public boolean remove(SAML11StatementAbstractType statement) {
        return this.statements.remove(statement);
    }

    public List<SAML11StatementAbstractType> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public SAML11ConditionsType getConditions() {
        return this.conditions;
    }

    public void setConditions(SAML11ConditionsType conditions) {
        this.conditions = conditions;
    }

    public SAML11AdviceType getAdvice() {
        return this.advice;
    }

    public void setAdvice(SAML11AdviceType advice) {
        this.advice = advice;
    }

    public Element getSignature() {
        return this.signature;
    }

    public void setSignature(Element signature) {
        this.signature = signature;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }
}

