/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.PemException;

public class PemUtils {
    private static final Logger log;

    public static X509Certificate decodeCertificate(String cert) {
        if (cert == null) {
            return null;
        }
        try {
            byte[] der = PemUtils.pemToDer(cert);
            ByteArrayInputStream bis = new ByteArrayInputStream(der);
            return PemUtils.decodeCertificate(bis);
        }
        catch (Exception e) {
            throw new PemException((Throwable)e);
        }
    }

    public static PublicKey decodePublicKey(String pem) {
        if (pem == null) {
            return null;
        }
        try {
            byte[] der = PemUtils.pemToDer(pem);
            return PemUtils.decodePublicKey(der, "RSA");
        }
        catch (Exception e) {
            throw new PemException((Throwable)e);
        }
    }

    public static PrivateKey decodePrivateKey(String pem) {
        if (pem == null) {
            return null;
        }
        try {
            byte[] der = PemUtils.pemToDer(pem);
            return PemUtils.decodePrivateKey(der);
        }
        catch (Exception e) {
            throw new PemException((Throwable)e);
        }
    }

    private static byte[] pemToDer(String pem) {
        try {
            pem = PemUtils.removeBeginEnd(pem);
            return Base64.decode((String)pem);
        }
        catch (IOException ioe) {
            throw new PemException((Throwable)ioe);
        }
    }

    private static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        return pem.trim();
    }

    private static PrivateKey decodePrivateKey(byte[] der) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(der);
        KeyFactory kf = KeyFactory.getInstance("RSA", "BC");
        return kf.generatePrivate(spec);
    }

    private static X509Certificate decodeCertificate(InputStream is) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        is.close();
        return cert;
    }

    private static PublicKey decodePublicKey(byte[] der, String type) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(der);
        KeyFactory kf = KeyFactory.getInstance("RSA", "BC");
        return kf.generatePublic(spec);
    }

    static {
        Provider bcProvider;
        log = Logger.getLogger(PemUtils.class);
        Provider existingBc = Security.getProvider("BC");
        Provider provider = bcProvider = existingBc == null ? new BouncyCastleProvider() : existingBc;
        if (existingBc == null) {
            Security.addProvider(bcProvider);
            log.debugv("Loaded {0} security provider", (Object)bcProvider.getClass().getName());
        } else {
            log.debugv("Security provider {0} already loaded", (Object)bcProvider.getClass().getName());
        }
    }
}

