/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.util.Objects;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;

public class SamlAuthenticationError
implements AuthenticationError {
    private Reason reason;
    private StatusResponseType status;

    public SamlAuthenticationError(Reason reason) {
        this.reason = reason;
    }

    public SamlAuthenticationError(Reason reason, StatusResponseType status) {
        this.reason = reason;
        this.status = status;
    }

    public SamlAuthenticationError(StatusResponseType statusType) {
        this.status = statusType;
    }

    public Reason getReason() {
        return this.reason;
    }

    public StatusResponseType getStatus() {
        return this.status;
    }

    public String toString() {
        return "SamlAuthenticationError [reason=" + String.valueOf((Object)this.reason) + ", status=" + (this.status == null || this.status.getStatus() == null ? "UNKNOWN" : this.extractStatusCode(this.status.getStatus().getStatusCode())) + "]";
    }

    private String extractStatusCode(StatusCodeType statusCode) {
        if (statusCode == null || statusCode.getValue() == null) {
            return "UNKNOWN";
        }
        if (Objects.equals(JBossSAMLURIConstants.STATUS_RESPONDER.get(), statusCode.getValue().toString())) {
            return this.extractStatusCode(statusCode.getStatusCode());
        }
        return statusCode.getValue().toString();
    }

    public static enum Reason {
        EXTRACTION_FAILURE,
        INVALID_SIGNATURE,
        ERROR_STATUS;

    }
}

