/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.lock;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.WriteResult;
import org.jboss.logging.Logger;
import org.keycloak.common.util.HostUtils;
import org.keycloak.common.util.Time;
import org.keycloak.connections.mongo.lock.MongoDBLockProviderFactory;
import org.keycloak.models.dblock.DBLockProvider;

public class MongoDBLockProvider
implements DBLockProvider {
    private static final String DB_LOCK_COLLECTION = "dblock";
    private static final Logger logger = Logger.getLogger(MongoDBLockProvider.class);
    private final MongoDBLockProviderFactory factory;
    private final DB db;

    public MongoDBLockProvider(MongoDBLockProviderFactory factory, DB db) {
        this.factory = factory;
        this.db = db;
    }

    public void waitForLock() {
        boolean locked = false;
        long startTime = Time.toMillis((int)Time.currentTime());
        long timeToGiveUp = startTime + this.factory.getLockWaitTimeoutMillis();
        while (!locked && Time.toMillis((int)Time.currentTime()) < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            int remainingTime = (int)(timeToGiveUp / 1000L) - Time.currentTime();
            logger.debugf("Waiting for changelog lock... Remaining time: %d seconds", remainingTime);
            try {
                Thread.sleep(this.factory.getLockRecheckTimeMillis());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!locked) {
            String lockedBy;
            BasicDBObject query = new BasicDBObject("_id", (Object)1);
            DBCursor cursor = this.db.getCollection(DB_LOCK_COLLECTION).find((DBObject)query);
            if (cursor.hasNext()) {
                DBObject dbObj = cursor.next();
                lockedBy = dbObj.get("lockedBy") + " since " + Time.toDate((int)((int)((Long)dbObj.get("lockedSince") / 1000L)));
            } else {
                lockedBy = "UNKNOWN";
            }
            throw new IllegalStateException("Could not acquire change log lock.  Currently locked by " + lockedBy);
        }
    }

    private boolean acquireLock() {
        BasicDBObject query = new BasicDBObject("locked", (Object)false);
        BasicDBObject update = new BasicDBObject("locked", (Object)true);
        update.append("_id", (Object)1);
        update.append("lockedSince", (Object)Time.toMillis((int)Time.currentTime()));
        update.append("lockedBy", (Object)HostUtils.getHostName());
        try {
            WriteResult wr = this.db.getCollection(DB_LOCK_COLLECTION).update((DBObject)query, (DBObject)update, true, false);
            if (wr.getN() == 1) {
                logger.debugf("Successfully acquired DB lock", new Object[0]);
                return true;
            }
            return false;
        }
        catch (DuplicateKeyException dke) {
            logger.debugf("Failed acquire lock. Reason: %s", (Object)dke.getMessage());
            return false;
        }
    }

    public void releaseLock() {
        BasicDBObject query = new BasicDBObject("locked", (Object)true);
        BasicDBObject update = new BasicDBObject("locked", (Object)false);
        update.append("_id", (Object)1);
        update.append("lockedBy", null);
        update.append("lockedSince", null);
        try {
            WriteResult wr = this.db.getCollection(DB_LOCK_COLLECTION).update((DBObject)query, (DBObject)update, true, false);
            if (wr.getN() > 0) {
                logger.debugf("Successfully released DB lock", new Object[0]);
            } else {
                logger.warnf("Attempt to release DB lock, but nothing was released", new Object[0]);
            }
        }
        catch (DuplicateKeyException dke) {
            logger.debugf("Failed release lock. Reason: %s", (Object)dke.getMessage());
        }
    }

    public boolean supportsForcedUnlock() {
        return true;
    }

    public void destroyLockInfo() {
        this.db.getCollection(DB_LOCK_COLLECTION).remove((DBObject)new BasicDBObject());
        logger.debugf("Destroyed lock collection", new Object[0]);
    }

    public void close() {
    }
}

