/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.lock;

import com.mongodb.DB;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.Time;
import org.keycloak.connections.mongo.MongoConnectionProvider;
import org.keycloak.connections.mongo.MongoConnectionProviderFactory;
import org.keycloak.connections.mongo.lock.MongoDBLockProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.dblock.DBLockProviderFactory;

public class MongoDBLockProviderFactory
implements DBLockProviderFactory {
    private static final Logger logger = Logger.getLogger(MongoDBLockProviderFactory.class);
    private long lockRecheckTimeMillis;
    private long lockWaitTimeoutMillis;

    protected long getLockRecheckTimeMillis() {
        return this.lockRecheckTimeMillis;
    }

    protected long getLockWaitTimeoutMillis() {
        return this.lockWaitTimeoutMillis;
    }

    public void init(Config.Scope config) {
        int lockRecheckTime = config.getInt("lockRecheckTime", Integer.valueOf(2));
        int lockWaitTimeout = config.getInt("lockWaitTimeout", Integer.valueOf(900));
        this.lockRecheckTimeMillis = Time.toMillis((int)lockRecheckTime);
        this.lockWaitTimeoutMillis = Time.toMillis((int)lockWaitTimeout);
        logger.debugf("Mongo lock provider configured with lockWaitTime: %d seconds, lockRecheckTime: %d seconds", lockWaitTimeout, lockRecheckTime);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public MongoDBLockProvider create(KeycloakSession session) {
        MongoConnectionProviderFactory mongoConnectionFactory = (MongoConnectionProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(MongoConnectionProvider.class);
        DB db = mongoConnectionFactory.getDBBeforeUpdate();
        return new MongoDBLockProvider(this, db);
    }

    public void setTimeouts(long lockRecheckTimeMillis, long lockWaitTimeoutMillis) {
        this.lockRecheckTimeMillis = lockRecheckTimeMillis;
        this.lockWaitTimeoutMillis = lockWaitTimeoutMillis;
    }

    public void close() {
    }

    public String getId() {
        return "mongo";
    }
}

