/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.impl.types;

import com.mongodb.BasicDBObject;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.types.Mapper;
import org.keycloak.connections.mongo.api.types.MapperContext;
import org.keycloak.connections.mongo.api.types.MapperRegistry;

public class MapMapper<T extends Map>
implements Mapper<T, BasicDBObject> {
    static final String DOT_PLACEHOLDER = "###";
    private final MapperRegistry mapperRegistry;
    private final Class<T> mapType;

    public MapMapper(MapperRegistry mapperRegistry, Class<T> mapType) {
        this.mapperRegistry = mapperRegistry;
        this.mapType = mapType;
    }

    @Override
    public BasicDBObject convertObject(MapperContext<T, BasicDBObject> context) {
        Map mapToConvert = (Map)context.getObjectToConvert();
        return MapMapper.convertMap(mapToConvert, this.mapperRegistry);
    }

    public static BasicDBObject convertMap(Map mapToConvert, MapperRegistry mapperRegistry) {
        BasicDBObject dbObject = new BasicDBObject();
        Set entries = mapToConvert.entrySet();
        for (Map.Entry entry : entries) {
            Object dbValue;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Object object = dbValue = mapperRegistry == null ? entry.getValue() : mapperRegistry.convertApplicationObjectToDBObject(value, Object.class);
            if (key.contains(".")) {
                key = key.replaceAll("\\.", DOT_PLACEHOLDER);
            }
            dbObject.put((Object)key, dbValue);
        }
        return dbObject;
    }

    @Override
    public Class<? extends T> getTypeOfObjectToConvert() {
        return this.mapType;
    }

    @Override
    public Class<BasicDBObject> getExpectedReturnType() {
        return BasicDBObject.class;
    }
}

