/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.entities.CredentialEntity;
import org.keycloak.models.entities.UserConsentEntity;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoUserConsentEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;
import org.keycloak.util.Time;

public class UserAdapter
extends AbstractMongoAdapter<MongoUserEntity>
implements UserModel {
    private final MongoUserEntity user;
    private final RealmModel realm;
    private final KeycloakSession session;

    public UserAdapter(KeycloakSession session, RealmModel realm, MongoUserEntity userEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.user = userEntity;
        this.realm = realm;
        this.session = session;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public void setUsername(String username) {
        this.user.setUsername(username);
        this.updateUser();
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
        this.updateUser();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
        this.updateUser();
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
        this.updateUser();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        this.user.setEmail(email);
        this.updateUser();
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
        this.updateUser();
    }

    public void setAttribute(String name, String value) {
        if (this.user.getAttributes() == null) {
            this.user.setAttributes(new HashMap());
        }
        this.user.getAttributes().put(name, value);
        this.updateUser();
    }

    public void removeAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return;
        }
        this.user.getAttributes().remove(name);
        this.updateUser();
    }

    public String getAttribute(String name) {
        return this.user.getAttributes() == null ? null : (String)this.user.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        return this.user.getAttributes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.user.getAttributes());
    }

    public MongoUserEntity getUser() {
        return this.user;
    }

    public Set<UserModel.RequiredAction> getRequiredActions() {
        HashSet<UserModel.RequiredAction> result = new HashSet<UserModel.RequiredAction>();
        if (this.user.getRequiredActions() != null) {
            result.addAll(this.user.getRequiredActions());
        }
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.user, "requiredActions", (Object)action, true, this.invocationContext);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.user, "requiredActions", (Object)action, this.invocationContext);
    }

    public boolean isTotp() {
        return this.user.isTotp();
    }

    public void setTotp(boolean totp) {
        this.user.setTotp(totp);
        this.updateUser();
    }

    public void updateCredential(UserCredentialModel cred) {
        if (cred.getType().equals("password")) {
            this.updatePasswordCredential(cred);
        } else {
            CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
            if (credentialEntity == null) {
                credentialEntity = this.setCredentials(this.user, cred);
                credentialEntity.setValue(cred.getValue());
                this.user.getCredentials().add(credentialEntity);
            } else {
                credentialEntity.setValue(cred.getValue());
            }
        }
        this.getMongoStore().updateEntity((MongoIdentifiableEntity)this.user, this.invocationContext);
    }

    private void updatePasswordCredential(UserCredentialModel cred) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = this.setCredentials(this.user, cred);
            this.setValue(credentialEntity, cred);
            this.user.getCredentials().add(credentialEntity);
        } else {
            int expiredPasswordsPolicyValue = -1;
            PasswordPolicy policy = this.realm.getPasswordPolicy();
            if (policy != null) {
                expiredPasswordsPolicyValue = policy.getExpiredPasswords();
            }
            if (expiredPasswordsPolicyValue != -1) {
                this.user.getCredentials().remove(credentialEntity);
                credentialEntity.setType("password-history");
                this.user.getCredentials().add(credentialEntity);
                List<CredentialEntity> credentialEntities = this.getCredentialEntities(this.user, "password-history");
                if (credentialEntities.size() > expiredPasswordsPolicyValue - 1) {
                    this.user.getCredentials().removeAll(credentialEntities.subList(expiredPasswordsPolicyValue - 1, credentialEntities.size()));
                }
                credentialEntity = this.setCredentials(this.user, cred);
                this.setValue(credentialEntity, cred);
                this.user.getCredentials().add(credentialEntity);
            } else {
                List<CredentialEntity> credentialEntities = this.getCredentialEntities(this.user, "password-history");
                if (credentialEntities != null && credentialEntities.size() > 0) {
                    this.user.getCredentials().removeAll(credentialEntities);
                }
                this.setValue(credentialEntity, cred);
            }
        }
    }

    private CredentialEntity setCredentials(MongoUserEntity user, UserCredentialModel cred) {
        CredentialEntity credentialEntity = new CredentialEntity();
        credentialEntity.setType(cred.getType());
        credentialEntity.setDevice(cred.getDevice());
        return credentialEntity;
    }

    private void setValue(CredentialEntity credentialEntity, UserCredentialModel cred) {
        byte[] salt = Pbkdf2PasswordEncoder.getSalt();
        int hashIterations = 1;
        PasswordPolicy policy = this.realm.getPasswordPolicy();
        if (policy != null && (hashIterations = policy.getHashIterations()) == -1) {
            hashIterations = 1;
        }
        credentialEntity.setCreatedDate(Long.valueOf(Time.toMillis((int)Time.currentTime())));
        credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue(), hashIterations));
        credentialEntity.setSalt(salt);
        credentialEntity.setHashIterations(hashIterations);
    }

    private CredentialEntity getCredentialEntity(MongoUserEntity userEntity, String credType) {
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            return entity;
        }
        return null;
    }

    private List<CredentialEntity> getCredentialEntities(MongoUserEntity userEntity, String credType) {
        ArrayList<CredentialEntity> credentialEntities = new ArrayList<CredentialEntity>();
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            credentialEntities.add(entity);
        }
        Collections.sort(credentialEntities, new Comparator<CredentialEntity>(){

            @Override
            public int compare(CredentialEntity credFirst, CredentialEntity credSecond) {
                if (credFirst.getCreatedDate() > credSecond.getCreatedDate()) {
                    return -1;
                }
                if (credFirst.getCreatedDate() < credSecond.getCreatedDate()) {
                    return 1;
                }
                return 0;
            }
        });
        return credentialEntities;
    }

    public List<UserCredentialValueModel> getCredentialsDirectly() {
        List credentials = this.user.getCredentials();
        ArrayList<UserCredentialValueModel> result = new ArrayList<UserCredentialValueModel>();
        for (CredentialEntity credEntity : credentials) {
            UserCredentialValueModel credModel = new UserCredentialValueModel();
            credModel.setType(credEntity.getType());
            credModel.setDevice(credEntity.getDevice());
            credModel.setCreatedDate(credEntity.getCreatedDate());
            credModel.setValue(credEntity.getValue());
            credModel.setSalt(credEntity.getSalt());
            credModel.setHashIterations(credEntity.getHashIterations());
            result.add(credModel);
        }
        return result;
    }

    public void updateCredentialDirectly(UserCredentialValueModel credModel) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, credModel.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(credModel.getType());
            credModel.setCreatedDate(credModel.getCreatedDate());
            this.user.getCredentials().add(credentialEntity);
        }
        credentialEntity.setValue(credModel.getValue());
        credentialEntity.setSalt(credModel.getSalt());
        credentialEntity.setDevice(credModel.getDevice());
        credentialEntity.setHashIterations(credModel.getHashIterations());
        this.getMongoStore().updateEntity((MongoIdentifiableEntity)this.user, this.invocationContext);
    }

    protected void updateUser() {
        super.updateMongoEntity();
    }

    @Override
    public MongoUserEntity getMongoEntity() {
        return this.user;
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void grantRole(RoleModel role) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.getUser(), "roleIds", (Object)role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getRoleMappings() {
        List<RoleModel> roles = MongoModelUtils.getAllRolesOfUser(this.realm, this);
        return new HashSet<RoleModel>(roles);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> allRoles = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allRoles) {
            if (!(role.getContainer() instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.getUser(), "roleIds", (Object)role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<RoleModel> roles = MongoModelUtils.getAllRolesOfUser(this.realm, this);
        for (RoleModel role : roles) {
            if (!app.equals(role.getContainer())) continue;
            result.add(role);
        }
        return result;
    }

    public String getFederationLink() {
        return this.user.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.user.setFederationLink(link);
        this.updateUser();
    }

    public void addConsent(UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        if (this.getConsentEntityByClientId(clientId) != null) {
            throw new ModelDuplicateException("Consent already exists for client [" + clientId + "] and user [" + this.user.getId() + "]");
        }
        MongoUserConsentEntity consentEntity = new MongoUserConsentEntity();
        consentEntity.setUserId(this.getId());
        consentEntity.setClientId(clientId);
        this.fillEntityFromModel(consent, consentEntity);
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)consentEntity, this.invocationContext);
    }

    public UserConsentModel getConsentByClient(String clientId) {
        MongoUserConsentEntity consentEntity = this.getConsentEntityByClientId(clientId);
        return consentEntity != null ? this.toConsentModel(consentEntity) : null;
    }

    public List<UserConsentModel> getConsents() {
        ArrayList<UserConsentModel> result = new ArrayList<UserConsentModel>();
        DBObject query = new QueryBuilder().and("userId").is((Object)this.getId()).get();
        List grantedConsents = this.getMongoStore().loadEntities(MongoUserConsentEntity.class, query, this.invocationContext);
        for (UserConsentEntity consentEntity : grantedConsents) {
            UserConsentModel model = this.toConsentModel(consentEntity);
            result.add(model);
        }
        return result;
    }

    private MongoUserConsentEntity getConsentEntityByClientId(String clientId) {
        DBObject query = new QueryBuilder().and("userId").is((Object)this.getId()).and("clientId").is((Object)clientId).get();
        return (MongoUserConsentEntity)this.getMongoStore().loadSingleEntity(MongoUserConsentEntity.class, query, this.invocationContext);
    }

    private UserConsentModel toConsentModel(UserConsentEntity entity) {
        ClientModel client = this.realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        for (String roleId : entity.getGrantedRoles()) {
            RoleModel roleModel = this.realm.getRoleById(roleId);
            if (roleModel == null) continue;
            model.addGrantedRole(roleModel);
        }
        for (String protMapperId : entity.getGrantedProtocolMappers()) {
            ProtocolMapperModel protocolMapper = client.getProtocolMapperById(protMapperId);
            model.addGrantedProtocolMapper(protocolMapper);
        }
        return model;
    }

    private void fillEntityFromModel(UserConsentModel consent, MongoUserConsentEntity consentEntity) {
        LinkedList<String> roleIds = new LinkedList<String>();
        for (RoleModel role : consent.getGrantedRoles()) {
            roleIds.add(role.getId());
        }
        consentEntity.setGrantedRoles(roleIds);
        LinkedList<String> protMapperIds = new LinkedList<String>();
        for (ProtocolMapperModel protMapperModel : consent.getGrantedProtocolMappers()) {
            protMapperIds.add(protMapperModel.getId());
        }
        consentEntity.setGrantedProtocolMappers(protMapperIds);
    }

    public void updateConsent(UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        MongoUserConsentEntity consentEntity = this.getConsentEntityByClientId(clientId);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + this.user.getId() + "]");
        }
        this.fillEntityFromModel(consent, consentEntity);
        this.getMongoStore().updateEntity((MongoIdentifiableEntity)consentEntity, this.invocationContext);
    }

    public boolean revokeConsentForClient(String clientId) {
        MongoUserConsentEntity entity = this.getConsentEntityByClientId(clientId);
        if (entity == null) {
            return false;
        }
        return this.getMongoStore().removeEntity((MongoIdentifiableEntity)entity, this.invocationContext);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

