/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.keys;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jboss.logging.Logger;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.models.KeycloakSession;

public class MapPublicKeyStorageProvider
implements PublicKeyStorageProvider {
    private static final Logger log = Logger.getLogger(MapPublicKeyStorageProvider.class);
    private final KeycloakSession session;
    private final Map<String, FutureTask<PublicKeysWrapper>> tasksInProgress;

    public MapPublicKeyStorageProvider(KeycloakSession session, Map<String, FutureTask<PublicKeysWrapper>> tasksInProgress) {
        this.session = session;
        this.tasksInProgress = tasksInProgress;
    }

    public KeyWrapper getFirstPublicKey(String modelKey, String algorithm, PublicKeyLoader loader) {
        return this.getPublicKey(modelKey, null, algorithm, loader);
    }

    public KeyWrapper getPublicKey(String modelKey, String kid, String algorithm, PublicKeyLoader loader) {
        PublicKeysWrapper currentKeys;
        WrapperCallable wrapperCallable = new WrapperCallable(modelKey, loader);
        FutureTask<PublicKeysWrapper> task = new FutureTask<PublicKeysWrapper>(wrapperCallable);
        FutureTask<PublicKeysWrapper> existing = this.tasksInProgress.putIfAbsent(modelKey, task);
        if (existing == null) {
            task.run();
        } else {
            task = existing;
        }
        try {
            currentKeys = task.get();
            KeyWrapper publicKey = currentKeys.getKeyByKidAndAlg(kid, algorithm);
            if (publicKey != null) {
                KeyWrapper keyWrapper = publicKey;
                return keyWrapper;
            }
        }
        catch (ExecutionException ee) {
            throw new RuntimeException("Error when loading public keys: " + ee.getMessage(), ee);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Error. Interrupted when loading public keys", ie);
        }
        finally {
            if (existing == null) {
                this.tasksInProgress.remove(modelKey);
            }
        }
        List availableKids = currentKeys == null ? Collections.emptyList() : currentKeys.getKids();
        log.warnf("PublicKey wasn't found in the storage. Requested kid: '%s' . Available kids: '%s'", (Object)kid, (Object)availableKids);
        return null;
    }

    public void close() {
    }

    private class WrapperCallable
    implements Callable<PublicKeysWrapper> {
        private final String modelKey;
        private final PublicKeyLoader delegate;

        public WrapperCallable(String modelKey, PublicKeyLoader delegate) {
            this.modelKey = modelKey;
            this.delegate = delegate;
        }

        @Override
        public PublicKeysWrapper call() throws Exception {
            PublicKeysWrapper publicKeys = this.delegate.loadKeys();
            if (log.isDebugEnabled()) {
                log.debugf("Public keys retrieved successfully for model %s. New kids: %s", (Object)this.modelKey, (Object)publicKeys.getKids());
            }
            return publicKeys;
        }
    }
}

