/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class TimeAdapter {
    private static final Logger LOG = Logger.getLogger(TimeAdapter.class);

    public static int fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(Long timestamp) {
        if (timestamp > Integer.MAX_VALUE) {
            LOG.warn((Object)"Trimmed time value found in the map store; value too large and not supported in core");
            return Integer.MAX_VALUE;
        }
        return timestamp.intValue();
    }

    public static long fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(int timestamp) {
        return timestamp;
    }

    public static Long fromSecondsToMilliseconds(Long seconds) {
        if (seconds == null) {
            return null;
        }
        return TimeUnit.SECONDS.toMillis(seconds);
    }

    public static Long fromMilliSecondsToSeconds(Long milliSeconds) {
        if (milliSeconds == null) {
            return null;
        }
        return TimeUnit.MILLISECONDS.toSeconds(milliSeconds);
    }

    public static Long fromSecondsToMilliseconds(int seconds) {
        return TimeAdapter.fromSecondsToMilliseconds(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(seconds));
    }
}

