/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.loginFailure;

import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureAdapter;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;

public class MapUserLoginFailureProvider
implements UserLoginFailureProvider {
    private static final Logger LOG = Logger.getLogger(MapUserLoginFailureProvider.class);
    private final KeycloakSession session;
    protected final MapStorage<MapUserLoginFailureEntity, UserLoginFailureModel> store;
    private final boolean storeHasRealmId;

    public MapUserLoginFailureProvider(KeycloakSession session, MapStorage<MapUserLoginFailureEntity, UserLoginFailureModel> userLoginFailureStore) {
        this.session = session;
        this.store = userLoginFailureStore;
        this.storeHasRealmId = this.store instanceof HasRealmId;
    }

    private MapStorage<MapUserLoginFailureEntity, UserLoginFailureModel> storeWithRealm(RealmModel realm) {
        if (this.storeHasRealmId) {
            ((HasRealmId)((Object)this.store)).setRealmId(realm == null ? null : realm.getId());
        }
        return this.store;
    }

    private Function<MapUserLoginFailureEntity, UserLoginFailureModel> userLoginFailureEntityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapUserLoginFailureAdapter(this.session, realm, (MapUserLoginFailureEntity)origEntity);
    }

    public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserLoginFailureModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userId});
        LOG.tracef("getUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb)).findFirst().map(this.userLoginFailureEntityToAdapterFunc(realm)).orElse(null);
    }

    public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserLoginFailureModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userId});
        LOG.tracef("addUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        MapUserLoginFailureEntity userLoginFailureEntity = this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb)).findFirst().orElse(null);
        if (userLoginFailureEntity == null) {
            userLoginFailureEntity = DeepCloner.DUMB_CLONER.newInstance(MapUserLoginFailureEntity.class);
            userLoginFailureEntity.setRealmId(realm.getId());
            userLoginFailureEntity.setUserId(userId);
            userLoginFailureEntity = this.storeWithRealm(realm).create(userLoginFailureEntity);
        }
        return this.userLoginFailureEntityToAdapterFunc(realm).apply(userLoginFailureEntity);
    }

    public void removeUserLoginFailure(RealmModel realm, String userId) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserLoginFailureModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userId});
        LOG.tracef("removeUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        this.storeWithRealm(realm).delete(QueryParameters.withCriteria(mcb));
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        LOG.tracef("removeAllUserLoginFailures(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.storeWithRealm(realm).delete(QueryParameters.withCriteria(mcb));
    }

    public void close() {
    }
}

