/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;

public class MapRootAuthenticationSessionEntityImpl
extends MapRootAuthenticationSessionEntity.AbstractRootAuthenticationSessionEntity
implements MapRootAuthenticationSessionEntity {
    private final DeepCloner cloner;
    private String fId;
    private Set<MapAuthenticationSessionEntity> fAuthenticationSessions;
    private Long fExpiration;
    private String fRealmId;
    private Long fTimestamp;

    private MapRootAuthenticationSessionEntityImpl() {
        this(DeepCloner.DUMB_CLONER);
    }

    public MapRootAuthenticationSessionEntityImpl(DeepCloner cloner) {
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapRootAuthenticationSessionEntityImpl)) {
            return false;
        }
        MapRootAuthenticationSessionEntityImpl other = (MapRootAuthenticationSessionEntityImpl)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAuthenticationSessions(), other.getAuthenticationSessions()) && Objects.equals(this.getExpiration(), other.getExpiration()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getTimestamp(), other.getTimestamp());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public <V> V deepClone(V obj) {
        return this.cloner.from(obj);
    }

    @Override
    public Optional<MapAuthenticationSessionEntity> getAuthenticationSession(String p0) {
        if (this.fAuthenticationSessions == null || this.fAuthenticationSessions.isEmpty()) {
            return Optional.empty();
        }
        return this.fAuthenticationSessions.stream().filter(o -> Objects.equals(o.getTabId(), p0)).findFirst();
    }

    @Override
    public Boolean removeAuthenticationSession(String p0) {
        boolean removed = this.fAuthenticationSessions != null && this.fAuthenticationSessions.removeIf(o -> Objects.equals(o.getTabId(), p0));
        this.updated |= removed;
        return removed;
    }

    @Override
    public void setAuthenticationSessions(Set<MapAuthenticationSessionEntity> p0) {
        Set<MapAuthenticationSessionEntity> set = p0 = p0 == null ? null : (Set<MapAuthenticationSessionEntity>)p0.stream().map(entry -> this.deepClone(entry)).collect(Collectors.toCollection(HashSet::new));
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fAuthenticationSessions, p0);
        this.fAuthenticationSessions = p0;
    }

    @Override
    public void addAuthenticationSession(MapAuthenticationSessionEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fAuthenticationSessions == null) {
            this.fAuthenticationSessions = new HashSet<MapAuthenticationSessionEntity>();
        }
        this.updated |= this.fAuthenticationSessions.add(p0);
    }

    @Override
    public Set<MapAuthenticationSessionEntity> getAuthenticationSessions() {
        return this.fAuthenticationSessions;
    }

    @Override
    public Long getExpiration() {
        return this.fExpiration;
    }

    @Override
    public void setExpiration(Long p0) {
        this.updated |= !Objects.equals(this.fExpiration, p0);
        this.fExpiration = p0;
    }

    @Override
    public void setRealmId(String p0) {
        this.updated |= !Objects.equals(this.fRealmId, p0);
        this.fRealmId = p0;
    }

    @Override
    public String getRealmId() {
        return this.fRealmId;
    }

    @Override
    public void setTimestamp(Long p0) {
        this.updated |= !Objects.equals(this.fTimestamp, p0);
        this.fTimestamp = p0;
    }

    @Override
    public Long getTimestamp() {
        return this.fTimestamp;
    }

    public static class Empty
    extends MapRootAuthenticationSessionEntity.AbstractRootAuthenticationSessionEntity
    implements MapRootAuthenticationSessionEntity {
        public static final Empty INSTANCE = new Empty();

        @Override
        public void setId(String id) {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public Optional<MapAuthenticationSessionEntity> getAuthenticationSession(String tabId) {
            return null;
        }

        @Override
        public Boolean removeAuthenticationSession(String tabId) {
            return null;
        }

        @Override
        public void setAuthenticationSessions(Set<MapAuthenticationSessionEntity> authenticationSessions) {
        }

        @Override
        public void addAuthenticationSession(MapAuthenticationSessionEntity authenticationSession) {
        }

        @Override
        public Set<MapAuthenticationSessionEntity> getAuthenticationSessions() {
            return null;
        }

        @Override
        public Long getExpiration() {
            return null;
        }

        @Override
        public void setExpiration(Long expiration) {
        }

        @Override
        public void setRealmId(String realmId) {
        }

        @Override
        public String getRealmId() {
            return null;
        }

        @Override
        public void setTimestamp(Long timestamp) {
        }

        @Override
        public Long getTimestamp() {
            return null;
        }

        @Override
        public boolean isUpdated() {
            return false;
        }
    }
}

