/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.lock;

import java.util.Objects;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.storage.SearchableModelField;

@DeepCloner.Root
public interface MapLockEntity
extends UpdatableEntity,
AbstractEntity {
    public String getName();

    public void setName(String var1);

    public String getKeycloakInstanceIdentifier();

    public void setKeycloakInstanceIdentifier(String var1);

    public Long getTimeAcquired();

    public void setTimeAcquired(Long var1);

    default public boolean isLockUnchanged(MapLockEntity otherMapLock) {
        return Objects.equals(this.getKeycloakInstanceIdentifier(), otherMapLock.getKeycloakInstanceIdentifier()) && Objects.equals(this.getTimeAcquired(), otherMapLock.getTimeAcquired()) && Objects.equals(this.getName(), otherMapLock.getName()) && Objects.equals(this.getId(), otherMapLock.getId());
    }

    public static abstract class AbstractLockEntity
    extends UpdatableEntity.Impl
    implements MapLockEntity {
        private String id;

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            if (this.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            this.id = id;
            this.updated |= id != null;
        }
    }

    public static class SearchableFields {
        public static final SearchableModelField<MapLockEntity> NAME = new SearchableModelField("name", String.class);
    }
}

