/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.criteria;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.ModelCriteriaNode;
import org.keycloak.storage.SearchableModelField;

public abstract class DescriptiveModelCriteria<M, Self extends DescriptiveModelCriteria<M, Self>>
implements ModelCriteriaBuilder<M, Self> {
    protected final ModelCriteriaNode<M> node;

    protected DescriptiveModelCriteria(ModelCriteriaNode<M> node) {
        this.node = node;
    }

    @Override
    public Self compare(SearchableModelField<? super M> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        return this.compare(new ModelCriteriaNode<M>(modelField, op, value));
    }

    private Self compare(ModelCriteriaNode<M> nodeToAdd) {
        ModelCriteriaNode<M> targetNode;
        if (this.isEmpty()) {
            targetNode = nodeToAdd;
        } else if (this.node.getNodeOperator() == ModelCriteriaNode.ExtOperator.AND) {
            targetNode = this.node.cloneTree();
            targetNode.addChild(nodeToAdd);
        } else {
            targetNode = new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.AND);
            targetNode.addChild(this.node.cloneTree());
            targetNode.addChild(nodeToAdd);
        }
        return this.instantiateForNode(targetNode);
    }

    protected abstract Self instantiateForNode(ModelCriteriaNode<M> var1);

    @Override
    public Self and(Self ... mcbs) {
        if (mcbs.length == 1) {
            return this.compare(((DescriptiveModelCriteria)mcbs[0]).node);
        }
        ModelCriteriaNode targetNode = new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.AND);
        AtomicBoolean hasFalseNode = new AtomicBoolean(false);
        for (Self mcb : mcbs) {
            ModelCriteriaNode<M> nodeToAdd = ((DescriptiveModelCriteria)mcb).node;
            this.getNodesToAddForAndOr(nodeToAdd, ModelCriteriaNode.ExtOperator.AND).filter(ModelCriteriaNode::isNotTrueNode).peek(n -> {
                if (n.isFalseNode()) {
                    hasFalseNode.lazySet(true);
                }
            }).map(ModelCriteriaNode::cloneTree).forEach(targetNode::addChild);
            if (!hasFalseNode.get()) continue;
            return this.compare(new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__FALSE__));
        }
        if (targetNode.getChildren().isEmpty()) {
            return this.compare(new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__TRUE__));
        }
        return this.compare(targetNode);
    }

    @Override
    public Self or(Self ... mcbs) {
        if (mcbs.length == 1) {
            return this.compare(((DescriptiveModelCriteria)mcbs[0]).node);
        }
        ModelCriteriaNode targetNode = new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.OR);
        AtomicBoolean hasTrueNode = new AtomicBoolean(false);
        for (Self mcb : mcbs) {
            ModelCriteriaNode<M> nodeToAdd = ((DescriptiveModelCriteria)mcb).node;
            this.getNodesToAddForAndOr(nodeToAdd, ModelCriteriaNode.ExtOperator.OR).filter(ModelCriteriaNode::isNotFalseNode).peek(n -> {
                if (n.isTrueNode()) {
                    hasTrueNode.lazySet(true);
                }
            }).map(ModelCriteriaNode::cloneTree).forEach(targetNode::addChild);
            if (!hasTrueNode.get()) continue;
            return this.compare(new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__TRUE__));
        }
        if (targetNode.getChildren().isEmpty()) {
            return this.compare(new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__FALSE__));
        }
        return this.compare(targetNode);
    }

    @Override
    public Self not(Self mcb) {
        ModelCriteriaNode<M> toBeChild = ((DescriptiveModelCriteria)mcb).node;
        if (toBeChild.getNodeOperator() == ModelCriteriaNode.ExtOperator.NOT) {
            return this.compare(((ModelCriteriaNode)toBeChild.getChildren().get(0)).cloneTree());
        }
        ModelCriteriaNode targetNode = new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.NOT);
        targetNode.addChild(toBeChild.cloneTree());
        return this.compare(targetNode);
    }

    public <C extends ModelCriteriaBuilder<M, C>> C flashToModelCriteriaBuilder(C mcb) {
        if (this.isEmpty()) {
            return mcb;
        }
        return mcb == null ? null : (C)this.node.flashToModelCriteriaBuilder(mcb);
    }

    public Self partiallyEvaluate(AtomicFormulaTester<M> tester) {
        return this.instantiateForNode(this.node.cloneTree((field, operator, operatorArguments) -> {
            Boolean res = tester.test(field, operator, operatorArguments);
            if (res == null) {
                return new ModelCriteriaNode(field, operator, operatorArguments);
            }
            return new ModelCriteriaNode(res != false ? ModelCriteriaNode.ExtOperator.__TRUE__ : ModelCriteriaNode.ExtOperator.__FALSE__);
        }, ModelCriteriaNode::new));
    }

    public Self optimize() {
        return (Self)((DescriptiveModelCriteria)this.flashToModelCriteriaBuilder((ModelCriteriaBuilder)this.instantiateForNode(null)));
    }

    public <T extends DescriptiveModelCriteria<?, ?>> Object getSingleRestrictionArgument(String fieldName) {
        if (this.node == null) {
            return null;
        }
        Self criterionFormula = ((DescriptiveModelCriteria)this.instantiateForNode(this.node.cloneTree(n -> {
            switch (n.getNodeOperator()) {
                case ATOMIC_FORMULA: {
                    if (fieldName.equals(n.getField().getName()) && n.getSimpleOperator() == ModelCriteriaBuilder.Operator.EQ) {
                        return new ModelCriteriaNode(n.getField(), n.getSimpleOperator(), n.getSimpleOperatorArguments());
                    }
                    return this.getNotParentsParity(n.getParent(), true) ? new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__TRUE__) : new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__FALSE__);
                }
            }
            return new ModelCriteriaNode(n.getNodeOperator());
        }))).optimize();
        ModelCriteriaNode<M> criterionFormulaRoot = ((DescriptiveModelCriteria)criterionFormula).getNode();
        if (criterionFormulaRoot.isFalseNode()) {
            return null;
        }
        if (criterionFormulaRoot.isTrueNode()) {
            return null;
        }
        ThreadLocal criterionArgument = new ThreadLocal();
        Optional<ModelCriteriaNode> firstInvalidNode = criterionFormulaRoot.findFirstDfs(n -> {
            switch (n.getNodeOperator()) {
                case NOT: {
                    return true;
                }
                case ATOMIC_FORMULA: {
                    Object argument = DescriptiveModelCriteria.getSingleArgument(n.getSimpleOperatorArguments());
                    if (argument != null) {
                        Object orig = criterionArgument.get();
                        if (orig != null && !Objects.equals(argument, orig)) {
                            return true;
                        }
                        criterionArgument.set(argument);
                    }
                    return false;
                }
            }
            return false;
        });
        return firstInvalidNode.isPresent() ? null : criterionArgument.get();
    }

    private static Object getSingleArgument(Object[] arguments) {
        if (arguments == null || arguments.length != 1) {
            return null;
        }
        Object a0 = arguments[0];
        if (a0 instanceof Collection) {
            Collection c0 = (Collection)a0;
            return c0.size() == 1 ? c0.iterator().next() : null;
        }
        return a0;
    }

    public boolean isEmpty() {
        return this.node == null;
    }

    public ModelCriteriaNode<M> getNode() {
        return this.node;
    }

    public String toString() {
        return this.isEmpty() ? "" : this.node.toString();
    }

    private Stream<ModelCriteriaNode<M>> getNodesToAddForAndOr(ModelCriteriaNode<M> nodeToAdd, ModelCriteriaNode.ExtOperator operatorBeingAdded) {
        ModelCriteriaNode.ExtOperator op = nodeToAdd.getNodeOperator();
        if (op == operatorBeingAdded) {
            return nodeToAdd.getChildren().stream();
        }
        return Stream.of(nodeToAdd);
    }

    private boolean getNotParentsParity(Optional<ModelCriteriaNode<M>> node, boolean currentValue) {
        return node.map(n -> this.getNotParentsParity(n.getParent(), n.getNodeOperator() == ModelCriteriaNode.ExtOperator.NOT ? !currentValue : currentValue)).orElse(currentValue);
    }

    @FunctionalInterface
    public static interface AtomicFormulaTester<M> {
        public Boolean test(SearchableModelField<? super M> var1, ModelCriteriaBuilder.Operator var2, Object[] var3);
    }
}

