/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.datastore;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.StackUtil;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.ClientScopeSpi;
import org.keycloak.models.ClientSpi;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.GroupSpi;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RealmSpi;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.RoleSpi;
import org.keycloak.models.ThemeManager;
import org.keycloak.models.TokenManager;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSpi;
import org.keycloak.models.map.client.MapClientProvider;
import org.keycloak.models.map.client.MapClientProviderFactory;
import org.keycloak.models.map.clientscope.MapClientScopeProvider;
import org.keycloak.models.map.clientscope.MapClientScopeProviderFactory;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.datastore.ImportSessionFactoryWrapper;
import org.keycloak.models.map.group.MapGroupProvider;
import org.keycloak.models.map.group.MapGroupProviderFactory;
import org.keycloak.models.map.realm.MapRealmProvider;
import org.keycloak.models.map.realm.MapRealmProviderFactory;
import org.keycloak.models.map.role.MapRoleProvider;
import org.keycloak.models.map.role.MapRoleProviderFactory;
import org.keycloak.models.map.user.MapUserProvider;
import org.keycloak.models.map.user.MapUserProviderFactory;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.Provider;
import org.keycloak.provider.Spi;
import org.keycloak.services.clientpolicy.ClientPolicyManager;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.vault.VaultTranscriber;

public class ImportKeycloakSession
implements KeycloakSession {
    private static final Logger LOG = Logger.getLogger(ImportKeycloakSession.class);
    private final KeycloakSessionFactory factory;
    private final KeycloakSession session;
    private final MapRealmProvider realmProvider;
    private final MapClientProvider clientProvider;
    private final MapClientScopeProvider clientScopeProvider;
    private final MapGroupProvider groupProvider;
    private final MapRoleProvider roleProvider;
    private final MapUserProvider userProvider;
    private final Set<AbstractMapProviderFactory<?, ?, ?>> providerFactories = new HashSet();

    public ImportKeycloakSession(ImportSessionFactoryWrapper factory, KeycloakSession session) {
        this.factory = factory;
        this.session = session;
        this.realmProvider = (MapRealmProvider)this.createProvider(RealmSpi.class, MapRealmProviderFactory.class);
        this.clientProvider = (MapClientProvider)this.createProvider(ClientSpi.class, MapClientProviderFactory.class);
        this.clientScopeProvider = (MapClientScopeProvider)this.createProvider(ClientScopeSpi.class, MapClientScopeProviderFactory.class);
        this.groupProvider = (MapGroupProvider)this.createProvider(GroupSpi.class, MapGroupProviderFactory.class);
        this.roleProvider = (MapRoleProvider)this.createProvider(RoleSpi.class, MapRoleProviderFactory.class);
        this.userProvider = (MapUserProvider)this.createProvider(UserSpi.class, MapUserProviderFactory.class);
    }

    private <P extends Provider, V extends AbstractEntity, M> P createProvider(Class<? extends Spi> spi, Class<? extends AbstractMapProviderFactory<P, V, M>> providerFactoryClass) {
        try {
            AbstractMapProviderFactory<P, V, M> providerFactory = providerFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            providerFactory.init(Config.scope((String[])new String[]{spi.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getName(), providerFactory.getId()}));
            this.providerFactories.add(providerFactory);
            return providerFactory.create(this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public KeycloakContext getContext() {
        return this.session.getContext();
    }

    public KeycloakTransactionManager getTransactionManager() {
        return this.session.getTransactionManager();
    }

    public <T extends Provider> T getProvider(Class<T> clazz) {
        LOG.warnf("Calling getProvider(%s) on the parent session. Revisit this to ensure it doesn't have side effects on the parent session.", (Object)clazz.getName(), StackUtil.getShortStackTrace());
        return (T)this.session.getProvider(clazz);
    }

    public <T extends Provider> T getProvider(Class<T> clazz, String id) {
        LOG.warnf("Calling getProvider(%s, %s) on the parent session. Revisit this to ensure it doesn't have side effects on the parent session.", (Object)clazz.getName(), (Object)id, StackUtil.getShortStackTrace());
        return (T)this.session.getProvider(clazz, id);
    }

    public <T extends Provider> T getComponentProvider(Class<T> clazz, String componentId) {
        LOG.warnf("Calling getComponentProvider(%s, %s) on the parent session. Revisit this to ensure it doesn't have side effects on the parent session.", (Object)clazz.getName(), (Object)componentId, StackUtil.getShortStackTrace());
        return (T)this.session.getComponentProvider(clazz, componentId);
    }

    public <T extends Provider> T getComponentProvider(Class<T> clazz, String componentId, Function<KeycloakSessionFactory, ComponentModel> modelGetter) {
        LOG.warnf("Calling getComponentProvider(%s, %s, ...) on the parent session. Revisit this to ensure it doesn't have side effects on the parent session.", (Object)clazz.getName(), (Object)componentId, StackUtil.getShortStackTrace());
        return (T)this.session.getComponentProvider(clazz, componentId, modelGetter);
    }

    public <T extends Provider> T getProvider(Class<T> clazz, ComponentModel componentModel) {
        LOG.warnf("Calling getProvider(%s, ...) on the parent session. Revisit this to ensure it doesn't have side effects on the parent session.", (Object)clazz.getName(), StackUtil.getShortStackTrace());
        return (T)this.session.getProvider(clazz, componentModel);
    }

    public <T extends Provider> Set<String> listProviderIds(Class<T> clazz) {
        LOG.warnf("Calling listProviderIds(%s, ...) on the parent session. Revisit this to ensure it doesn't have side effects on the parent session.", (Object)clazz.getName(), StackUtil.getShortStackTrace());
        return this.session.listProviderIds(clazz);
    }

    public <T extends Provider> Set<T> getAllProviders(Class<T> clazz) {
        LOG.warnf("Calling getAllProviders(%s) on the parent session. Revisit this to ensure it doesn't have side effects on the parent session.", (Object)clazz.getName(), StackUtil.getShortStackTrace());
        return this.session.getAllProviders(clazz);
    }

    public Class<? extends Provider> getProviderClass(String providerClassName) {
        LOG.warnf("Calling getProviderClass(%s) on the parent session. Revisit this to ensure it doesn't have side effects on the parent session.", (Object)providerClassName, StackUtil.getShortStackTrace());
        return this.session.getProviderClass(providerClassName);
    }

    public Object getAttribute(String attribute) {
        return this.session.getAttribute(attribute);
    }

    public <T> T getAttribute(String attribute, Class<T> clazz) {
        return (T)this.session.getAttribute(attribute, clazz);
    }

    public <T> T getAttributeOrDefault(String attribute, T defaultValue) {
        return (T)this.session.getAttributeOrDefault(attribute, defaultValue);
    }

    public Object removeAttribute(String attribute) {
        return this.session.removeAttribute(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    public Map<String, Object> getAttributes() {
        return this.session.getAttributes();
    }

    public void invalidate(InvalidationHandler.InvalidableObjectType type, Object ... ids) {
        this.providerFactories.stream().filter(InvalidationHandler.class::isInstance).map(InvalidationHandler.class::cast).forEach(ih -> ih.invalidate((KeycloakSession)this, type, ids));
    }

    public void enlistForClose(Provider provider) {
        this.session.enlistForClose(provider);
    }

    public KeycloakSessionFactory getKeycloakSessionFactory() {
        return this.factory;
    }

    public RealmProvider realms() {
        return this.realmProvider;
    }

    public ClientProvider clients() {
        return this.clientProvider;
    }

    public ClientScopeProvider clientScopes() {
        return this.clientScopeProvider;
    }

    public GroupProvider groups() {
        return this.groupProvider;
    }

    public RoleProvider roles() {
        return this.roleProvider;
    }

    public UserSessionProvider sessions() {
        throw new ModelException("not supported yet");
    }

    public UserLoginFailureProvider loginFailures() {
        throw new ModelException("not supported yet");
    }

    public AuthenticationSessionProvider authenticationSessions() {
        throw new ModelException("not supported yet");
    }

    public void close() {
        this.session.close();
    }

    @Deprecated
    public UserProvider userCache() {
        throw new ModelException("not supported");
    }

    public UserProvider users() {
        return this.userProvider;
    }

    @Deprecated
    public ClientProvider clientStorageManager() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public ClientScopeProvider clientScopeStorageManager() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public RoleProvider roleStorageManager() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public GroupProvider groupStorageManager() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public UserProvider userStorageManager() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public UserCredentialManager userCredentialManager() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public UserProvider userLocalStorage() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public RealmProvider realmLocalStorage() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public ClientProvider clientLocalStorage() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public ClientScopeProvider clientScopeLocalStorage() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public GroupProvider groupLocalStorage() {
        throw new ModelException("not supported");
    }

    @Deprecated
    public RoleProvider roleLocalStorage() {
        throw new ModelException("not supported");
    }

    public KeyManager keys() {
        throw new ModelException("not supported");
    }

    public ThemeManager theme() {
        throw new ModelException("not supported");
    }

    public TokenManager tokens() {
        throw new ModelException("not supported");
    }

    public VaultTranscriber vault() {
        throw new ModelException("not supported");
    }

    public ClientPolicyManager clientPolicy() {
        return this.session.clientPolicy();
    }
}

