/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.events;

import java.util.Arrays;
import java.util.Date;
import java.util.stream.Stream;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.storage.SearchableModelField;

public abstract class MapAdminEventQuery
implements AdminEventQuery {
    private Integer firstResult;
    private Integer maxResults;
    private QueryParameters.Order order = QueryParameters.Order.DESCENDING;
    private DefaultModelCriteria<AdminEvent> mcb = DefaultModelCriteria.criteria();
    protected String realmId;

    public AdminEventQuery realm(String realmId) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realmId});
        this.realmId = realmId;
        return this;
    }

    public AdminEventQuery authRealm(String realmId) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.AUTH_REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realmId});
        return this;
    }

    public AdminEventQuery authClient(String clientId) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.AUTH_CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{clientId});
        return this;
    }

    public AdminEventQuery authUser(String userId) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.AUTH_USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userId});
        return this;
    }

    public AdminEventQuery authIpAddress(String ipAddress) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.AUTH_IP_ADDRESS, ModelCriteriaBuilder.Operator.EQ, new Object[]{ipAddress});
        return this;
    }

    public AdminEventQuery operation(OperationType ... operations) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.OPERATION_TYPE, ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.stream(operations)});
        return this;
    }

    public AdminEventQuery resourceType(ResourceType ... resourceTypes) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.RESOURCE_TYPE, ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.stream(resourceTypes)});
        return this;
    }

    public AdminEventQuery resourcePath(String resourcePath) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.RESOURCE_PATH, ModelCriteriaBuilder.Operator.LIKE, new Object[]{resourcePath.replace('*', '%')});
        return this;
    }

    public AdminEventQuery fromTime(Date fromTime) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.TIMESTAMP, ModelCriteriaBuilder.Operator.GE, new Object[]{fromTime.getTime()});
        return this;
    }

    public AdminEventQuery toTime(Date toTime) {
        this.mcb = (DefaultModelCriteria)this.mcb.compare(AdminEvent.SearchableFields.TIMESTAMP, ModelCriteriaBuilder.Operator.LE, new Object[]{toTime.getTime()});
        return this;
    }

    public AdminEventQuery firstResult(int first) {
        this.firstResult = first;
        return this;
    }

    public AdminEventQuery maxResults(int max) {
        this.maxResults = max;
        return this;
    }

    public AdminEventQuery orderByDescTime() {
        this.order = QueryParameters.Order.DESCENDING;
        return this;
    }

    public AdminEventQuery orderByAscTime() {
        this.order = QueryParameters.Order.ASCENDING;
        return this;
    }

    public Stream<AdminEvent> getResultStream() {
        return this.read(QueryParameters.withCriteria(this.mcb).offset(this.firstResult).limit(this.maxResults).orderBy((SearchableModelField<AdminEvent>)AdminEvent.SearchableFields.TIMESTAMP, this.order));
    }

    protected abstract Stream<AdminEvent> read(QueryParameters<AdminEvent> var1);
}

