/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.datastore;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.map.datastore.ImportKeycloakSession;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorageProviderFactory;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;

public class ImportSessionFactoryWrapper
implements KeycloakSessionFactory {
    private ConcurrentHashMapStorageProviderFactory concurrentHashMapStorageProviderFactory;
    private final KeycloakSessionFactory keycloakSessionFactory;

    public KeycloakSession create() {
        this.concurrentHashMapStorageProviderFactory = new ConcurrentHashMapStorageProviderFactory();
        this.concurrentHashMapStorageProviderFactory.init(Config.scope((String[])new String[]{"mapStorage", this.concurrentHashMapStorageProviderFactory.getId()}));
        return new ImportKeycloakSession(this, this.keycloakSessionFactory.create());
    }

    public Set<Spi> getSpis() {
        return this.keycloakSessionFactory.getSpis();
    }

    public Spi getSpi(Class<? extends Provider> providerClass) {
        return this.keycloakSessionFactory.getSpi(providerClass);
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz) {
        if (clazz == MapStorageProvider.class) {
            return this.keycloakSessionFactory.getProviderFactory(clazz, "concurrenthashmap");
        }
        return this.keycloakSessionFactory.getProviderFactory(clazz);
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String id) {
        if (clazz == MapStorageProvider.class) {
            return this.concurrentHashMapStorageProviderFactory;
        }
        return this.keycloakSessionFactory.getProviderFactory(clazz, id);
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String realmId, String componentId, Function<KeycloakSessionFactory, ComponentModel> modelGetter) {
        return this.keycloakSessionFactory.getProviderFactory(clazz, realmId, componentId, modelGetter);
    }

    public Stream<ProviderFactory> getProviderFactoriesStream(Class<? extends Provider> clazz) {
        return this.keycloakSessionFactory.getProviderFactoriesStream(clazz);
    }

    public long getServerStartupTimestamp() {
        return this.keycloakSessionFactory.getServerStartupTimestamp();
    }

    public void close() {
        this.keycloakSessionFactory.close();
    }

    public void invalidate(KeycloakSession session, InvalidationHandler.InvalidableObjectType type, Object ... params) {
        this.keycloakSessionFactory.invalidate(session, type, params);
    }

    public void register(ProviderEventListener listener) {
        this.keycloakSessionFactory.register(listener);
    }

    public void unregister(ProviderEventListener listener) {
        this.keycloakSessionFactory.unregister(listener);
    }

    public void publish(ProviderEvent event) {
        this.keycloakSessionFactory.publish(event);
    }

    public ImportSessionFactoryWrapper(KeycloakSessionFactory keycloakSessionFactory) {
        this.keycloakSessionFactory = keycloakSessionFactory;
    }
}

