/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionProvider;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.sessions.AuthenticationSessionProviderFactory;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class MapRootAuthenticationSessionProviderFactory
extends AbstractMapProviderFactory<MapRootAuthenticationSessionProvider, MapRootAuthenticationSessionEntity, RootAuthenticationSessionModel>
implements AuthenticationSessionProviderFactory<MapRootAuthenticationSessionProvider> {
    public static final String AUTH_SESSIONS_LIMIT = "authSessionsLimit";
    public static final int DEFAULT_AUTH_SESSIONS_LIMIT = 300;
    private int authSessionsLimit;

    public MapRootAuthenticationSessionProviderFactory() {
        super(RootAuthenticationSessionModel.class, MapRootAuthenticationSessionProvider.class);
    }

    @Override
    public void init(Config.Scope config) {
        super.init(config);
        int configInt = config.getInt(AUTH_SESSIONS_LIMIT, Integer.valueOf(300));
        this.authSessionsLimit = configInt <= 0 ? 300 : configInt;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(AUTH_SESSIONS_LIMIT).type("int").helpText("The maximum number of concurrent authentication sessions per RootAuthenticationSession.").defaultValue((Object)300).add().build();
    }

    @Override
    public MapRootAuthenticationSessionProvider createNew(KeycloakSession session) {
        return new MapRootAuthenticationSessionProvider(session, this.getStorage(session), this.authSessionsLimit);
    }

    public String getHelpText() {
        return "Authentication session provider";
    }
}

