/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.adapter;

import java.util.Objects;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.adapter.AbstractScopeModel;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;

public class MapScopeAdapter
extends AbstractScopeModel<MapScopeEntity> {
    private final RealmModel realm;
    private ResourceServer resourceServer;

    public MapScopeAdapter(RealmModel realm, ResourceServer resourceServer, MapScopeEntity entity, StoreFactory storeFactory) {
        super(entity, storeFactory);
        Objects.requireNonNull(realm);
        this.realm = realm;
        this.resourceServer = resourceServer;
    }

    public String getId() {
        return ((MapScopeEntity)this.entity).getId();
    }

    public String getName() {
        return ((MapScopeEntity)this.entity).getName();
    }

    public void setName(String name) {
        this.throwExceptionIfReadonly();
        ((MapScopeEntity)this.entity).setName(name);
    }

    public String getDisplayName() {
        return ((MapScopeEntity)this.entity).getDisplayName();
    }

    public void setDisplayName(String name) {
        this.throwExceptionIfReadonly();
        ((MapScopeEntity)this.entity).setDisplayName(name);
    }

    public String getIconUri() {
        return ((MapScopeEntity)this.entity).getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.throwExceptionIfReadonly();
        ((MapScopeEntity)this.entity).setIconUri(iconUri);
    }

    public ResourceServer getResourceServer() {
        if (this.resourceServer == null) {
            this.resourceServer = this.storeFactory.getResourceServerStore().findById(this.realm, ((MapScopeEntity)this.entity).getResourceServerId());
        }
        return this.resourceServer;
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode((Object)this));
    }
}

