/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.role;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.role.AbstractRoleModel;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MapRoleAdapter
extends AbstractRoleModel<MapRoleEntity>
implements RoleModel {
    private static final Logger LOG = Logger.getLogger(MapRoleAdapter.class);

    public MapRoleAdapter(KeycloakSession session, RealmModel realm, MapRoleEntity entity) {
        super(session, realm, entity);
    }

    public String getId() {
        return ((MapRoleEntity)this.entity).getId();
    }

    public String getName() {
        return ((MapRoleEntity)this.entity).getName();
    }

    public String getDescription() {
        return ((MapRoleEntity)this.entity).getDescription();
    }

    public void setDescription(String description) {
        ((MapRoleEntity)this.entity).setDescription(description);
    }

    public void setName(String name) {
        ((MapRoleEntity)this.entity).setName(name);
    }

    public boolean isComposite() {
        return ((MapRoleEntity)this.entity).getCompositeRoles() != null && !((MapRoleEntity)this.entity).getCompositeRoles().isEmpty();
    }

    public Stream<RoleModel> getCompositesStream() {
        Set compositeRoles = ((MapRoleEntity)this.entity).getCompositeRoles() == null ? Collections.emptySet() : ((MapRoleEntity)this.entity).getCompositeRoles();
        LOG.tracef("%% %s(%s).getCompositesStream():%d - %s", new Object[]{((MapRoleEntity)this.entity).getName(), ((MapRoleEntity)this.entity).getId(), compositeRoles.size(), StackUtil.getShortStackTrace()});
        return compositeRoles.stream().map(uuid -> this.session.roles().getRoleById(this.realm, uuid)).filter(Objects::nonNull);
    }

    public Stream<RoleModel> getCompositesStream(String search, Integer first, Integer max) {
        Set compositeRoles = ((MapRoleEntity)this.entity).getCompositeRoles() == null ? Collections.emptySet() : ((MapRoleEntity)this.entity).getCompositeRoles();
        LOG.tracef("%% (%s).getCompositesStream(%s, %d, %d):%d - %s", new Object[]{this, search, first, max, compositeRoles.size(), StackUtil.getShortStackTrace()});
        return this.session.roles().getRolesStream(this.realm, compositeRoles.stream(), search, first, max);
    }

    public void addCompositeRole(RoleModel role) {
        LOG.tracef("(%s).addCompositeRole(%s(%s))%s", new Object[]{this, role.getName(), role.getId(), StackUtil.getShortStackTrace()});
        ((MapRoleEntity)this.entity).addCompositeRole(role.getId());
    }

    public void removeCompositeRole(RoleModel role) {
        LOG.tracef("(%s).removeCompositeRole(%s(%s))%s", new Object[]{this, role.getName(), role.getId(), StackUtil.getShortStackTrace()});
        ((MapRoleEntity)this.entity).removeCompositeRole(role.getId());
    }

    public boolean isClientRole() {
        Boolean clientRole = ((MapRoleEntity)this.entity).isClientRole();
        return clientRole == null ? false : clientRole;
    }

    public String getContainerId() {
        return this.isClientRole() ? ((MapRoleEntity)this.entity).getClientId() : ((MapRoleEntity)this.entity).getRealmId();
    }

    public RoleContainerModel getContainer() {
        return this.isClientRole() ? this.session.clients().getClientById(this.realm, ((MapRoleEntity)this.entity).getClientId()) : this.realm;
    }

    public void setAttribute(String name, List<String> values) {
        ((MapRoleEntity)this.entity).setAttribute(name, values);
    }

    public void setSingleAttribute(String name, String value) {
        this.setAttribute(name, Collections.singletonList(value));
    }

    public void removeAttribute(String name) {
        ((MapRoleEntity)this.entity).removeAttribute(name);
    }

    public Map<String, List<String>> getAttributes() {
        Map<String, List<String>> attributes = ((MapRoleEntity)this.entity).getAttributes();
        return attributes == null ? Collections.emptyMap() : attributes;
    }

    public boolean hasRole(RoleModel role) {
        return this.equals(role) || KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, new HashSet());
    }

    public Stream<String> getAttributeStream(String name) {
        return this.getAttributes().getOrDefault(name, Collections.EMPTY_LIST).stream();
    }

    public String toString() {
        return String.format("%s@%08x", this.getName(), System.identityHashCode(this));
    }
}

