/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityWithAttributes;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;

@DeepCloner.Root
public interface MapRealmEntity
extends UpdatableEntity,
AbstractEntity,
EntityWithAttributes {
    public String getName();

    public void setName(String var1);

    public String getDisplayName();

    public void setDisplayName(String var1);

    public String getDisplayNameHtml();

    public void setDisplayNameHtml(String var1);

    public Boolean isEnabled();

    public void setEnabled(Boolean var1);

    public Boolean isRegistrationAllowed();

    public void setRegistrationAllowed(Boolean var1);

    public Boolean isRegistrationEmailAsUsername();

    public void setRegistrationEmailAsUsername(Boolean var1);

    public Boolean isVerifyEmail();

    public void setVerifyEmail(Boolean var1);

    public Boolean isResetPasswordAllowed();

    public void setResetPasswordAllowed(Boolean var1);

    public Boolean isLoginWithEmailAllowed();

    public void setLoginWithEmailAllowed(Boolean var1);

    public Boolean isDuplicateEmailsAllowed();

    public void setDuplicateEmailsAllowed(Boolean var1);

    public Boolean isRememberMe();

    public void setRememberMe(Boolean var1);

    public Boolean isEditUsernameAllowed();

    public void setEditUsernameAllowed(Boolean var1);

    public Boolean isRevokeRefreshToken();

    public void setRevokeRefreshToken(Boolean var1);

    public Boolean isAdminEventsEnabled();

    public void setAdminEventsEnabled(Boolean var1);

    public Boolean isAdminEventsDetailsEnabled();

    public void setAdminEventsDetailsEnabled(Boolean var1);

    public Boolean isInternationalizationEnabled();

    public void setInternationalizationEnabled(Boolean var1);

    public Boolean isAllowUserManagedAccess();

    public void setAllowUserManagedAccess(Boolean var1);

    public Boolean isOfflineSessionMaxLifespanEnabled();

    public void setOfflineSessionMaxLifespanEnabled(Boolean var1);

    public Boolean isEventsEnabled();

    public void setEventsEnabled(Boolean var1);

    public Integer getRefreshTokenMaxReuse();

    public void setRefreshTokenMaxReuse(Integer var1);

    public Integer getSsoSessionIdleTimeout();

    public void setSsoSessionIdleTimeout(Integer var1);

    public Integer getSsoSessionMaxLifespan();

    public void setSsoSessionMaxLifespan(Integer var1);

    public Integer getSsoSessionIdleTimeoutRememberMe();

    public void setSsoSessionIdleTimeoutRememberMe(Integer var1);

    public Integer getSsoSessionMaxLifespanRememberMe();

    public void setSsoSessionMaxLifespanRememberMe(Integer var1);

    public Integer getOfflineSessionIdleTimeout();

    public void setOfflineSessionIdleTimeout(Integer var1);

    public Integer getAccessTokenLifespan();

    public void setAccessTokenLifespan(Integer var1);

    public Integer getAccessTokenLifespanForImplicitFlow();

    public void setAccessTokenLifespanForImplicitFlow(Integer var1);

    public Integer getAccessCodeLifespan();

    public void setAccessCodeLifespan(Integer var1);

    public Integer getAccessCodeLifespanUserAction();

    public void setAccessCodeLifespanUserAction(Integer var1);

    public Integer getAccessCodeLifespanLogin();

    public void setAccessCodeLifespanLogin(Integer var1);

    public Long getNotBefore();

    public void setNotBefore(Long var1);

    public Integer getClientSessionIdleTimeout();

    public void setClientSessionIdleTimeout(Integer var1);

    public Integer getClientSessionMaxLifespan();

    public void setClientSessionMaxLifespan(Integer var1);

    public Integer getClientOfflineSessionIdleTimeout();

    public void setClientOfflineSessionIdleTimeout(Integer var1);

    public Integer getClientOfflineSessionMaxLifespan();

    public void setClientOfflineSessionMaxLifespan(Integer var1);

    public Integer getActionTokenGeneratedByAdminLifespan();

    public void setActionTokenGeneratedByAdminLifespan(Integer var1);

    public Integer getOfflineSessionMaxLifespan();

    public void setOfflineSessionMaxLifespan(Integer var1);

    public Long getEventsExpiration();

    public void setEventsExpiration(Long var1);

    public String getPasswordPolicy();

    public void setPasswordPolicy(String var1);

    public String getSslRequired();

    public void setSslRequired(String var1);

    public String getLoginTheme();

    public void setLoginTheme(String var1);

    public String getAccountTheme();

    public void setAccountTheme(String var1);

    public String getAdminTheme();

    public void setAdminTheme(String var1);

    public String getEmailTheme();

    public void setEmailTheme(String var1);

    public String getMasterAdminClient();

    public void setMasterAdminClient(String var1);

    public String getDefaultRoleId();

    public void setDefaultRoleId(String var1);

    public String getDefaultLocale();

    public void setDefaultLocale(String var1);

    public String getBrowserFlow();

    public void setBrowserFlow(String var1);

    public String getRegistrationFlow();

    public void setRegistrationFlow(String var1);

    public String getDirectGrantFlow();

    public void setDirectGrantFlow(String var1);

    public String getResetCredentialsFlow();

    public void setResetCredentialsFlow(String var1);

    public String getClientAuthenticationFlow();

    public void setClientAuthenticationFlow(String var1);

    public String getDockerAuthenticationFlow();

    public void setDockerAuthenticationFlow(String var1);

    public MapOTPPolicyEntity getOTPPolicy();

    public void setOTPPolicy(MapOTPPolicyEntity var1);

    public MapWebAuthnPolicyEntity getWebAuthnPolicy();

    public void setWebAuthnPolicy(MapWebAuthnPolicyEntity var1);

    public MapWebAuthnPolicyEntity getWebAuthnPolicyPasswordless();

    public void setWebAuthnPolicyPasswordless(MapWebAuthnPolicyEntity var1);

    public Set<String> getDefaultClientScopeIds();

    public void addDefaultClientScopeId(String var1);

    public Boolean removeDefaultClientScopeId(String var1);

    public Set<String> getOptionalClientScopeIds();

    public void addOptionalClientScopeId(String var1);

    public Boolean removeOptionalClientScopeId(String var1);

    public Set<String> getDefaultGroupIds();

    public void addDefaultGroupId(String var1);

    public void removeDefaultGroupId(String var1);

    public Set<String> getEventsListeners();

    public void setEventsListeners(Set<String> var1);

    public Set<String> getEnabledEventTypes();

    public void setEnabledEventTypes(Set<String> var1);

    public Set<String> getSupportedLocales();

    public void setSupportedLocales(Set<String> var1);

    public Map<String, Map<String, String>> getLocalizationTexts();

    public Map<String, String> getLocalizationText(String var1);

    public void setLocalizationText(String var1, Map<String, String> var2);

    public Boolean removeLocalizationText(String var1);

    public Map<String, String> getBrowserSecurityHeaders();

    public void setBrowserSecurityHeaders(Map<String, String> var1);

    public void setBrowserSecurityHeader(String var1, String var2);

    public Map<String, String> getSmtpConfig();

    public void setSmtpConfig(Map<String, String> var1);

    public Set<MapRequiredCredentialEntity> getRequiredCredentials();

    public void addRequiredCredential(MapRequiredCredentialEntity var1);

    public Set<MapComponentEntity> getComponents();

    public Optional<MapComponentEntity> getComponent(String var1);

    public void addComponent(MapComponentEntity var1);

    public Boolean removeComponent(String var1);

    public Set<MapAuthenticationFlowEntity> getAuthenticationFlows();

    public Optional<MapAuthenticationFlowEntity> getAuthenticationFlow(String var1);

    public void addAuthenticationFlow(MapAuthenticationFlowEntity var1);

    public Boolean removeAuthenticationFlow(String var1);

    public Set<MapAuthenticationExecutionEntity> getAuthenticationExecutions();

    public Optional<MapAuthenticationExecutionEntity> getAuthenticationExecution(String var1);

    public void addAuthenticationExecution(MapAuthenticationExecutionEntity var1);

    public Boolean removeAuthenticationExecution(String var1);

    public Set<MapAuthenticatorConfigEntity> getAuthenticatorConfigs();

    public void addAuthenticatorConfig(MapAuthenticatorConfigEntity var1);

    public Optional<MapAuthenticatorConfigEntity> getAuthenticatorConfig(String var1);

    public Boolean removeAuthenticatorConfig(String var1);

    public Set<MapRequiredActionProviderEntity> getRequiredActionProviders();

    public void addRequiredActionProvider(MapRequiredActionProviderEntity var1);

    public Optional<MapRequiredActionProviderEntity> getRequiredActionProvider(String var1);

    public Boolean removeRequiredActionProvider(String var1);

    public Set<MapIdentityProviderEntity> getIdentityProviders();

    public void addIdentityProvider(MapIdentityProviderEntity var1);

    public Boolean removeIdentityProvider(String var1);

    public Set<MapIdentityProviderMapperEntity> getIdentityProviderMappers();

    public void addIdentityProviderMapper(MapIdentityProviderMapperEntity var1);

    public Boolean removeIdentityProviderMapper(String var1);

    public Optional<MapIdentityProviderMapperEntity> getIdentityProviderMapper(String var1);

    public Set<MapClientInitialAccessEntity> getClientInitialAccesses();

    public void addClientInitialAccess(MapClientInitialAccessEntity var1);

    public Optional<MapClientInitialAccessEntity> getClientInitialAccess(String var1);

    public Boolean removeClientInitialAccess(String var1);

    @IgnoreForEntityImplementationGenerator
    public void removeExpiredClientInitialAccesses();

    @IgnoreForEntityImplementationGenerator
    public boolean hasClientInitialAccess();

    public static abstract class AbstractRealmEntity
    extends UpdatableEntity.Impl
    implements MapRealmEntity {
        private String id;

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            if (this.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            this.id = id;
            this.updated |= id != null;
        }

        @Override
        public boolean isUpdated() {
            return this.updated || Optional.ofNullable(this.getAuthenticationExecutions()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getAuthenticationFlows()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getAuthenticatorConfigs()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getClientInitialAccesses()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getComponents()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getIdentityProviders()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getIdentityProviderMappers()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getRequiredActionProviders()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getRequiredCredentials()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated) || Optional.ofNullable(this.getOTPPolicy()).map(UpdatableEntity::isUpdated).orElse(false) != false || Optional.ofNullable(this.getWebAuthnPolicy()).map(UpdatableEntity::isUpdated).orElse(false) != false || Optional.ofNullable(this.getWebAuthnPolicyPasswordless()).map(UpdatableEntity::isUpdated).orElse(false) != false;
        }

        @Override
        public void clearUpdatedFlag() {
            this.updated = false;
            Optional.ofNullable(this.getAuthenticationExecutions()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getAuthenticationFlows()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getAuthenticatorConfigs()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getClientInitialAccesses()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getComponents()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getIdentityProviders()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getIdentityProviderMappers()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getRequiredActionProviders()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getRequiredCredentials()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getOTPPolicy()).ifPresent(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getWebAuthnPolicy()).ifPresent(UpdatableEntity::clearUpdatedFlag);
            Optional.ofNullable(this.getWebAuthnPolicyPasswordless()).ifPresent(UpdatableEntity::clearUpdatedFlag);
        }

        @Override
        public Optional<MapComponentEntity> getComponent(String componentId) {
            Set<MapComponentEntity> cs = this.getComponents();
            if (cs == null || cs.isEmpty()) {
                return Optional.empty();
            }
            return cs.stream().filter(c -> Objects.equals(c.getId(), componentId)).findFirst();
        }

        @Override
        public Boolean removeComponent(String componentId) {
            Set<MapComponentEntity> cs = this.getComponents();
            boolean removed = cs != null && cs.removeIf(c -> Objects.equals(c.getId(), componentId));
            this.updated |= removed;
            return removed;
        }

        @Override
        public Optional<MapAuthenticationFlowEntity> getAuthenticationFlow(String flowId) {
            Set<MapAuthenticationFlowEntity> afs = this.getAuthenticationFlows();
            if (afs == null || afs.isEmpty()) {
                return Optional.empty();
            }
            return afs.stream().filter(afe -> Objects.equals(afe.getId(), flowId)).findFirst();
        }

        @Override
        public Boolean removeAuthenticationFlow(String flowId) {
            Set<MapAuthenticationFlowEntity> afs = this.getAuthenticationFlows();
            boolean removed = afs != null && afs.removeIf(af -> Objects.equals(af.getId(), flowId));
            this.updated |= removed;
            return removed;
        }

        @Override
        public Optional<MapAuthenticationExecutionEntity> getAuthenticationExecution(String executionId) {
            Set<MapAuthenticationExecutionEntity> aes = this.getAuthenticationExecutions();
            if (aes == null || aes.isEmpty()) {
                return Optional.empty();
            }
            return aes.stream().filter(ae -> Objects.equals(ae.getId(), executionId)).findFirst();
        }

        @Override
        public Boolean removeAuthenticationExecution(String executionId) {
            Set<MapAuthenticationExecutionEntity> aes = this.getAuthenticationExecutions();
            boolean removed = aes != null && aes.removeIf(ae -> Objects.equals(ae.getId(), executionId));
            this.updated |= removed;
            return removed;
        }

        @Override
        public Optional<MapAuthenticatorConfigEntity> getAuthenticatorConfig(String authenticatorConfigId) {
            Set<MapAuthenticatorConfigEntity> acs = this.getAuthenticatorConfigs();
            if (acs == null || acs.isEmpty()) {
                return Optional.empty();
            }
            return acs.stream().filter(ac -> Objects.equals(ac.getId(), authenticatorConfigId)).findFirst();
        }

        @Override
        public Boolean removeAuthenticatorConfig(String authenticatorConfigId) {
            Set<MapAuthenticatorConfigEntity> acs = this.getAuthenticatorConfigs();
            boolean removed = acs != null && acs.removeIf(ac -> Objects.equals(ac.getId(), authenticatorConfigId));
            this.updated |= removed;
            return removed;
        }

        @Override
        public Optional<MapRequiredActionProviderEntity> getRequiredActionProvider(String requiredActionProviderId) {
            Set<MapRequiredActionProviderEntity> raps = this.getRequiredActionProviders();
            if (raps == null || raps.isEmpty()) {
                return Optional.empty();
            }
            return raps.stream().filter(ac -> Objects.equals(ac.getId(), requiredActionProviderId)).findFirst();
        }

        @Override
        public Boolean removeRequiredActionProvider(String requiredActionProviderId) {
            Set<MapRequiredActionProviderEntity> raps = this.getRequiredActionProviders();
            boolean removed = raps != null && raps.removeIf(rap -> Objects.equals(rap.getId(), requiredActionProviderId));
            this.updated |= removed;
            return removed;
        }

        @Override
        public Boolean removeIdentityProvider(String identityProviderId) {
            Set<MapIdentityProviderEntity> ips = this.getIdentityProviders();
            boolean removed = ips != null && ips.removeIf(ip -> Objects.equals(ip.getId(), identityProviderId));
            this.updated |= removed;
            return removed;
        }

        @Override
        public Optional<MapIdentityProviderMapperEntity> getIdentityProviderMapper(String identityProviderMapperId) {
            Set<MapIdentityProviderMapperEntity> ipms = this.getIdentityProviderMappers();
            if (ipms == null || ipms.isEmpty()) {
                return Optional.empty();
            }
            return ipms.stream().filter(ipm -> Objects.equals(ipm.getId(), identityProviderMapperId)).findFirst();
        }

        @Override
        public Boolean removeIdentityProviderMapper(String identityProviderMapperId) {
            Set<MapIdentityProviderMapperEntity> ipms = this.getIdentityProviderMappers();
            boolean removed = ipms != null && ipms.removeIf(ipm -> Objects.equals(ipm.getId(), identityProviderMapperId));
            this.updated |= removed;
            return removed;
        }

        @Override
        public Optional<MapClientInitialAccessEntity> getClientInitialAccess(String clientInitialAccessId) {
            Set<MapClientInitialAccessEntity> cias = this.getClientInitialAccesses();
            if (cias == null || cias.isEmpty()) {
                return Optional.empty();
            }
            return cias.stream().filter(cia -> Objects.equals(cia.getId(), clientInitialAccessId)).findFirst();
        }

        @Override
        public Boolean removeClientInitialAccess(String clientInitialAccessId) {
            Set<MapClientInitialAccessEntity> cias = this.getClientInitialAccesses();
            boolean removed = cias != null && cias.removeIf(cia -> Objects.equals(cia.getId(), clientInitialAccessId));
            this.updated |= removed;
            return removed;
        }

        @Override
        public void removeExpiredClientInitialAccesses() {
            Set<MapClientInitialAccessEntity> cias = this.getClientInitialAccesses();
            if (cias != null) {
                cias.stream().filter(this::checkIfExpired).map(AbstractEntity::getId).collect(Collectors.toSet()).forEach(this::removeClientInitialAccess);
            }
        }

        @Override
        public boolean hasClientInitialAccess() {
            Set<MapClientInitialAccessEntity> cias = this.getClientInitialAccesses();
            return cias != null && !cias.isEmpty();
        }

        private boolean checkIfExpired(MapClientInitialAccessEntity cia) {
            return cia.getRemainingCount() < 1 || ExpirationUtils.isExpired(cia, true);
        }
    }
}

