/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.events;

import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.common.ExpirableEntity;
import org.keycloak.models.map.common.ExpirationUtils;
import org.keycloak.models.map.events.EventUtils;
import org.keycloak.models.map.events.MapAdminEventEntity;
import org.keycloak.models.map.events.MapAdminEventQuery;
import org.keycloak.models.map.events.MapAuthEventEntity;
import org.keycloak.models.map.events.MapAuthEventQuery;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;

public class MapEventStoreProvider
implements EventStoreProvider {
    private static final Logger LOG = Logger.getLogger(MapEventStoreProvider.class);
    private final KeycloakSession session;
    private final MapKeycloakTransaction<MapAuthEventEntity, Event> authEventsTX;
    private final MapKeycloakTransaction<MapAdminEventEntity, AdminEvent> adminEventsTX;

    public MapEventStoreProvider(KeycloakSession session, MapStorage<MapAuthEventEntity, Event> loginEventsStore, MapStorage<MapAdminEventEntity, AdminEvent> adminEventsStore) {
        this.session = session;
        this.authEventsTX = loginEventsStore.createTransaction(session);
        this.adminEventsTX = adminEventsStore.createTransaction(session);
        session.getTransactionManager().enlistAfterCompletion(this.authEventsTX);
        session.getTransactionManager().enlistAfterCompletion(this.adminEventsTX);
    }

    public void onEvent(Event event) {
        RealmModel realm;
        LOG.tracef("onEvent(%s)%s", (Object)event, StackUtil.getShortStackTrace());
        String id = event.getId();
        if (id != null && this.authEventsTX.read(id) != null) {
            throw new ModelDuplicateException("Event already exists: " + id);
        }
        MapAuthEventEntity entity = EventUtils.modelToEntity(event);
        String realmId = event.getRealmId();
        if (realmId != null && (realm = this.session.realms().getRealm(realmId)) != null && realm.getEventsExpiration() > 0L) {
            entity.setExpiration(Time.currentTimeMillis() + realm.getEventsExpiration() * 1000L);
        }
        this.authEventsTX.create(entity);
    }

    private boolean filterExpired(ExpirableEntity event) {
        if (ExpirationUtils.isExpired(event, true)) {
            this.authEventsTX.delete(event.getId());
            return false;
        }
        return true;
    }

    public EventQuery createQuery() {
        LOG.tracef("createQuery()%s", StackUtil.getShortStackTrace());
        return new MapAuthEventQuery(((Function<QueryParameters, Stream>)this.authEventsTX::read).andThen(s -> s.filter(this::filterExpired).map(EventUtils::entityToModel)));
    }

    public void clear() {
        LOG.tracef("clear()%s", StackUtil.getShortStackTrace());
        this.authEventsTX.delete(QueryParameters.withCriteria(DefaultModelCriteria.criteria()));
    }

    public void clear(RealmModel realm) {
        LOG.tracef("clear(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.authEventsTX.delete(QueryParameters.withCriteria(DefaultModelCriteria.criteria().compare(Event.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})));
    }

    public void clear(RealmModel realm, long olderThan) {
        LOG.tracef("clear(%s, %d)%s", (Object)realm, (Object)olderThan, StackUtil.getShortStackTrace());
        this.authEventsTX.delete(QueryParameters.withCriteria(((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(Event.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(Event.SearchableFields.TIMESTAMP, ModelCriteriaBuilder.Operator.LT, new Object[]{olderThan})));
    }

    public void clearExpiredEvents() {
        LOG.tracef("clearExpiredEvents()%s", StackUtil.getShortStackTrace());
        LOG.warnf("Clearing expired entities should not be triggered manually. It is responsibility of the store to clear these.", new Object[0]);
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        LOG.tracef("clear(%s, %s)%s", (Object)event, (Object)includeRepresentation, StackUtil.getShortStackTrace());
        String id = event.getId();
        if (id != null && this.authEventsTX.read(id) != null) {
            throw new ModelDuplicateException("Event already exists: " + id);
        }
        String realmId = event.getRealmId();
        MapAdminEventEntity entity = EventUtils.modelToEntity(event, includeRepresentation);
        if (realmId != null) {
            RealmModel realm = this.session.realms().getRealm(realmId);
            Long expiration = realm.getAttribute("adminEventsExpiration", Long.valueOf(0L));
            if (realm != null && expiration > 0L) {
                entity.setExpiration(Time.currentTimeMillis() + expiration * 1000L);
            }
        }
        this.adminEventsTX.create(entity);
    }

    public AdminEventQuery createAdminQuery() {
        LOG.tracef("createAdminQuery()%s", StackUtil.getShortStackTrace());
        return new MapAdminEventQuery(((Function<QueryParameters, Stream>)this.adminEventsTX::read).andThen(s -> s.filter(this::filterExpired).map(EventUtils::entityToModel)));
    }

    public void clearAdmin() {
        LOG.tracef("clearAdmin()%s", StackUtil.getShortStackTrace());
        this.adminEventsTX.delete(QueryParameters.withCriteria(DefaultModelCriteria.criteria()));
    }

    public void clearAdmin(RealmModel realm) {
        LOG.tracef("clear(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.adminEventsTX.delete(QueryParameters.withCriteria(DefaultModelCriteria.criteria().compare(AdminEvent.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})));
    }

    public void clearAdmin(RealmModel realm, long olderThan) {
        LOG.tracef("clearAdmin(%s, %d)%s", (Object)realm, (Object)olderThan, StackUtil.getShortStackTrace());
        this.adminEventsTX.delete(QueryParameters.withCriteria(((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(AdminEvent.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(AdminEvent.SearchableFields.TIMESTAMP, ModelCriteriaBuilder.Operator.LT, new Object[]{olderThan})));
    }

    public void close() {
    }
}

