/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntityImpl;

public class MapProtocolMapperUtils {
    private final String protocol;
    private static final ConcurrentMap<String, MapProtocolMapperUtils> INSTANCES = new ConcurrentHashMap<String, MapProtocolMapperUtils>();

    private MapProtocolMapperUtils(String protocol) {
        this.protocol = protocol;
    }

    public static MapProtocolMapperUtils instanceFor(String protocol) {
        Objects.requireNonNull(protocol);
        return INSTANCES.computeIfAbsent(protocol, MapProtocolMapperUtils::new);
    }

    public static MapProtocolMapperEntity fromModel(ProtocolMapperModel model) {
        MapProtocolMapperEntityImpl res = new MapProtocolMapperEntityImpl();
        res.setId(model.getId());
        res.setName(model.getName());
        res.setProtocolMapper(model.getProtocolMapper());
        res.setConfig(model.getConfig());
        return res;
    }

    public ProtocolMapperModel toModel(MapProtocolMapperEntity entity) {
        ProtocolMapperModel res = new ProtocolMapperModel();
        res.setId(entity.getId());
        res.setName(entity.getName());
        res.setProtocolMapper(entity.getProtocolMapper());
        Map<String, String> config = entity.getConfig();
        res.setConfig(config == null ? new HashMap() : new HashMap<String, String>(config));
        res.setProtocol(this.protocol);
        return res;
    }
}

