/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.ExpirableEntity;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;

@DeepCloner.Root
public interface MapUserSessionEntity
extends AbstractEntity,
UpdatableEntity,
ExpirableEntity {
    public String getRealmId();

    public void setRealmId(String var1);

    public String getUserId();

    public void setUserId(String var1);

    public String getBrokerSessionId();

    public void setBrokerSessionId(String var1);

    public String getBrokerUserId();

    public void setBrokerUserId(String var1);

    public String getLoginUsername();

    public void setLoginUsername(String var1);

    public String getIpAddress();

    public void setIpAddress(String var1);

    public String getAuthMethod();

    public void setAuthMethod(String var1);

    public Boolean isRememberMe();

    public void setRememberMe(Boolean var1);

    public Long getTimestamp();

    public void setTimestamp(Long var1);

    public Long getLastSessionRefresh();

    public void setLastSessionRefresh(Long var1);

    public Map<String, String> getNotes();

    public String getNote(String var1);

    public void setNotes(Map<String, String> var1);

    public Boolean removeNote(String var1);

    public void setNote(String var1, String var2);

    public UserSessionModel.State getState();

    public void setState(UserSessionModel.State var1);

    public Set<MapAuthenticatedClientSessionEntity> getAuthenticatedClientSessions();

    public Optional<MapAuthenticatedClientSessionEntity> getAuthenticatedClientSession(String var1);

    public void addAuthenticatedClientSession(MapAuthenticatedClientSessionEntity var1);

    public Boolean removeAuthenticatedClientSession(String var1);

    @IgnoreForEntityImplementationGenerator
    public void clearAuthenticatedClientSessions();

    public Boolean isOffline();

    public void setOffline(Boolean var1);

    public UserSessionModel.SessionPersistenceState getPersistenceState();

    public void setPersistenceState(UserSessionModel.SessionPersistenceState var1);

    public static abstract class AbstractUserSessionEntity
    extends UpdatableEntity.Impl
    implements MapUserSessionEntity {
        private String id;

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            if (this.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            this.id = id;
            this.updated |= id != null;
        }

        @Override
        public boolean isUpdated() {
            return this.updated || Optional.ofNullable(this.getAuthenticatedClientSessions()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated);
        }

        @Override
        public void clearUpdatedFlag() {
            this.updated = false;
            Optional.ofNullable(this.getAuthenticatedClientSessions()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
        }

        @Override
        public Optional<MapAuthenticatedClientSessionEntity> getAuthenticatedClientSession(String clientUUID) {
            Set<MapAuthenticatedClientSessionEntity> acss = this.getAuthenticatedClientSessions();
            if (acss == null || acss.isEmpty()) {
                return Optional.empty();
            }
            return acss.stream().filter(acs -> Objects.equals(acs.getClientId(), clientUUID)).findFirst();
        }

        @Override
        public Boolean removeAuthenticatedClientSession(String clientUUID) {
            Set<MapAuthenticatedClientSessionEntity> acss = this.getAuthenticatedClientSessions();
            boolean removed = acss != null && acss.removeIf(uc -> Objects.equals(uc.getClientId(), clientUUID));
            this.updated |= removed;
            return removed;
        }

        @Override
        public void clearAuthenticatedClientSessions() {
            Set<MapAuthenticatedClientSessionEntity> acss = this.getAuthenticatedClientSessions();
            if (acss != null) {
                acss.stream().map(MapAuthenticatedClientSessionEntity::getClientId).collect(Collectors.toSet()).forEach(this::removeAuthenticatedClientSession);
            }
        }
    }
}

