/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.singleUseObject;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.singleUseObject.AbstractSingleUseObjectModel;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntity;

public class MapSingleUseObjectAdapter
extends AbstractSingleUseObjectModel<MapSingleUseObjectEntity> {
    public MapSingleUseObjectAdapter(KeycloakSession session, MapSingleUseObjectEntity entity) {
        super(session, entity);
    }

    public String getUserId() {
        return ((MapSingleUseObjectEntity)this.entity).getUserId();
    }

    public String getActionId() {
        return ((MapSingleUseObjectEntity)this.entity).getActionId();
    }

    public int getExpiration() {
        Long expiration = ((MapSingleUseObjectEntity)this.entity).getExpiration();
        return expiration != null ? TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(TimeAdapter.fromMilliSecondsToSeconds(expiration)) : 0;
    }

    public UUID getActionVerificationNonce() {
        String actionVerificationNonce = ((MapSingleUseObjectEntity)this.entity).getActionVerificationNonce();
        return actionVerificationNonce != null ? UUID.fromString(actionVerificationNonce) : null;
    }

    public Map<String, String> getNotes() {
        Map<String, String> notes = ((MapSingleUseObjectEntity)this.entity).getNotes();
        return notes == null ? Collections.emptyMap() : Collections.unmodifiableMap(notes);
    }

    public String getNote(String name) {
        Map<String, String> notes = ((MapSingleUseObjectEntity)this.entity).getNotes();
        return notes == null ? null : notes.get(name);
    }
}

