/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionProvider;
import org.keycloak.provider.InvalidationHandler;

public class MapUserSessionProviderFactory
extends AbstractMapProviderFactory<MapUserSessionProvider, MapUserSessionEntity, UserSessionModel>
implements UserSessionProviderFactory<MapUserSessionProvider>,
InvalidationHandler {
    public MapUserSessionProviderFactory() {
        super(UserSessionModel.class, MapUserSessionProvider.class);
    }

    @Override
    public MapUserSessionProvider createNew(KeycloakSession session) {
        return new MapUserSessionProvider(session, this.getStorage(session));
    }

    public String getHelpText() {
        return "User session provider";
    }

    public void invalidate(KeycloakSession session, InvalidationHandler.InvalidableObjectType type, Object ... params) {
        if (type == AbstractMapProviderFactory.MapProviderObjectType.USER_BEFORE_REMOVE) {
            ((MapUserSessionProvider)this.create(session)).removeUserSessions((RealmModel)params[0], (UserModel)params[1]);
        } else if (type == AbstractMapProviderFactory.MapProviderObjectType.REALM_BEFORE_REMOVE) {
            ((MapUserSessionProvider)this.create(session)).removeAllUserSessions((RealmModel)params[0]);
        }
    }

    public void loadPersistentSessions(KeycloakSessionFactory sessionFactory, int maxErrors, int sessionsPerSegment) {
    }
}

