/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntityImpl;

@DeepCloner.Root
public interface MapWebAuthnPolicyEntity
extends UpdatableEntity {
    public static MapWebAuthnPolicyEntity fromModel(WebAuthnPolicy model) {
        if (model == null) {
            return null;
        }
        MapWebAuthnPolicyEntityImpl entity = new MapWebAuthnPolicyEntityImpl();
        entity.setRpEntityName(model.getRpEntityName());
        entity.setSignatureAlgorithms(model.getSignatureAlgorithm());
        entity.setRpId(model.getRpId());
        entity.setAttestationConveyancePreference(model.getAttestationConveyancePreference());
        entity.setAuthenticatorAttachment(model.getAuthenticatorAttachment());
        entity.setRequireResidentKey(model.getRequireResidentKey());
        entity.setUserVerificationRequirement(model.getUserVerificationRequirement());
        entity.setCreateTimeout(model.getCreateTimeout());
        entity.setAvoidSameAuthenticatorRegister(model.isAvoidSameAuthenticatorRegister());
        entity.setAcceptableAaguids(model.getAcceptableAaguids());
        return entity;
    }

    public static WebAuthnPolicy toModel(MapWebAuthnPolicyEntity entity) {
        if (entity == null) {
            return null;
        }
        WebAuthnPolicy model = new WebAuthnPolicy();
        model.setRpEntityName(entity.getRpEntityName());
        model.setSignatureAlgorithm(entity.getSignatureAlgorithms());
        model.setRpId(entity.getRpId());
        model.setAttestationConveyancePreference(entity.getAttestationConveyancePreference());
        model.setAuthenticatorAttachment(entity.getAuthenticatorAttachment());
        model.setRequireResidentKey(entity.getRequireResidentKey());
        model.setUserVerificationRequirement(entity.getUserVerificationRequirement());
        model.setCreateTimeout(entity.getCreateTimeout().intValue());
        model.setAvoidSameAuthenticatorRegister(entity.isAvoidSameAuthenticatorRegister().booleanValue());
        List<String> acceptableAaguids = entity.getAcceptableAaguids();
        model.setAcceptableAaguids(acceptableAaguids == null ? new LinkedList() : new LinkedList<String>(acceptableAaguids));
        return model;
    }

    public static MapWebAuthnPolicyEntity defaultWebAuthnPolicy() {
        MapWebAuthnPolicyEntityImpl entity = new MapWebAuthnPolicyEntityImpl();
        entity.setRpEntityName("keycloak");
        entity.setSignatureAlgorithms(Arrays.asList("ES256".split(",")));
        entity.setRpId("");
        entity.setAttestationConveyancePreference("not specified");
        entity.setAuthenticatorAttachment("not specified");
        entity.setRequireResidentKey("not specified");
        entity.setUserVerificationRequirement("not specified");
        entity.setCreateTimeout(0);
        entity.setAvoidSameAuthenticatorRegister(false);
        entity.setAcceptableAaguids(new LinkedList<String>());
        return entity;
    }

    public String getRpEntityName();

    public void setRpEntityName(String var1);

    public List<String> getSignatureAlgorithms();

    public void setSignatureAlgorithms(List<String> var1);

    public String getRpId();

    public void setRpId(String var1);

    public String getAttestationConveyancePreference();

    public void setAttestationConveyancePreference(String var1);

    public String getAuthenticatorAttachment();

    public void setAuthenticatorAttachment(String var1);

    public String getRequireResidentKey();

    public void setRequireResidentKey(String var1);

    public String getUserVerificationRequirement();

    public void setUserVerificationRequirement(String var1);

    public Integer getCreateTimeout();

    public void setCreateTimeout(Integer var1);

    public Boolean isAvoidSameAuthenticatorRegister();

    public void setAvoidSameAuthenticatorRegister(Boolean var1);

    public List<String> getAcceptableAaguids();

    public void setAcceptableAaguids(List<String> var1);
}

