/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.keys;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import org.keycloak.common.Profile;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.PublicKeyStorageProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.keys.MapPublicKeyStorageProvider;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class MapPublicKeyStorageProviderFactory
extends AbstractMapProviderFactory<MapPublicKeyStorageProvider, AbstractEntity, Object>
implements PublicKeyStorageProviderFactory<MapPublicKeyStorageProvider>,
EnvironmentDependentProviderFactory {
    private final Map<String, FutureTask<Map<String, KeyWrapper>>> tasksInProgress = new ConcurrentHashMap<String, FutureTask<Map<String, KeyWrapper>>>();

    public MapPublicKeyStorageProviderFactory() {
        super(Object.class, MapPublicKeyStorageProvider.class);
    }

    @Override
    public MapPublicKeyStorageProvider createNew(KeycloakSession session) {
        return new MapPublicKeyStorageProvider(session, this.tasksInProgress);
    }

    @Override
    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public String getHelpText() {
        return "Public key storage provider";
    }
}

