/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.events;

import java.util.Arrays;
import java.util.Date;
import java.util.function.Function;
import java.util.stream.Stream;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventType;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.storage.SearchableModelField;

public class MapAuthEventQuery
implements EventQuery {
    private Integer firstResult;
    private Integer maxResults;
    private DefaultModelCriteria<Event> mcb = DefaultModelCriteria.criteria();
    private final Function<QueryParameters<Event>, Stream<Event>> resultProducer;

    public MapAuthEventQuery(Function<QueryParameters<Event>, Stream<Event>> resultProducer) {
        this.resultProducer = resultProducer;
    }

    public EventQuery type(EventType ... types) {
        this.mcb = this.mcb.compare(Event.SearchableFields.EVENT_TYPE, ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.asList(types)});
        return this;
    }

    public EventQuery realm(String realmId) {
        this.mcb = this.mcb.compare(Event.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realmId});
        return this;
    }

    public EventQuery client(String clientId) {
        this.mcb = this.mcb.compare(Event.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{clientId});
        return this;
    }

    public EventQuery user(String userId) {
        this.mcb = this.mcb.compare(Event.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userId});
        return this;
    }

    public EventQuery fromDate(Date fromDate) {
        this.mcb = this.mcb.compare(Event.SearchableFields.TIMESTAMP, ModelCriteriaBuilder.Operator.GE, new Object[]{fromDate.getTime()});
        return this;
    }

    public EventQuery toDate(Date toDate) {
        this.mcb = this.mcb.compare(Event.SearchableFields.TIMESTAMP, ModelCriteriaBuilder.Operator.LE, new Object[]{toDate.getTime()});
        return this;
    }

    public EventQuery ipAddress(String ipAddress) {
        this.mcb = this.mcb.compare(Event.SearchableFields.IP_ADDRESS, ModelCriteriaBuilder.Operator.EQ, new Object[]{ipAddress});
        return this;
    }

    public EventQuery firstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public EventQuery maxResults(int max) {
        this.maxResults = max;
        return this;
    }

    public Stream<Event> getResultStream() {
        return this.resultProducer.apply(QueryParameters.withCriteria(this.mcb).offset(this.firstResult).limit(this.maxResults).orderBy((SearchableModelField<Event>)Event.SearchableFields.TIMESTAMP, QueryParameters.Order.DESCENDING));
    }
}

