/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.adapter.MapScopeAdapter;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.authorization.entity.MapScopeEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.storage.SearchableModelField;

public class MapScopeStore
implements ScopeStore {
    private static final Logger LOG = Logger.getLogger(MapScopeStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<MapScopeEntity, Scope> tx;
    private final KeycloakSession session;

    public MapScopeStore(KeycloakSession session, MapStorage<MapScopeEntity, Scope> scopeStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.tx = scopeStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
        this.session = session;
    }

    private Function<MapScopeEntity, Scope> entityToAdapterFunc(RealmModel realm, ResourceServer resourceServer) {
        return origEntity -> new MapScopeAdapter(realm, resourceServer, (MapScopeEntity)origEntity, this.authorizationProvider.getStoreFactory());
    }

    private DefaultModelCriteria<Scope> forRealmAndResourceServer(RealmModel realm, ResourceServer resourceServer) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria().compare(Scope.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        return resourceServer == null ? mcb : ((DefaultModelCriteria)mcb).compare(Scope.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resourceServer.getId()});
    }

    public Scope create(ResourceServer resourceServer, String id, String name) {
        LOG.tracef("create(%s, %s, %s)%s", new Object[]{id, name, resourceServer, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        ModelCriteriaBuilder mcb = this.forRealmAndResourceServer(realm, resourceServer).compare(Scope.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        if (this.tx.getCount(QueryParameters.withCriteria(mcb)) > 0L) {
            throw new ModelDuplicateException("Scope with name '" + name + "' for " + resourceServer.getId() + " already exists");
        }
        MapScopeEntity entity = new MapScopeEntityImpl();
        entity.setId(id);
        entity.setName(name);
        entity.setResourceServerId(resourceServer.getId());
        entity.setRealmId(resourceServer.getRealm().getId());
        entity = this.tx.create(entity);
        return entity == null ? null : this.entityToAdapterFunc(realm, resourceServer).apply(entity);
    }

    public void delete(RealmModel realm, String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        Scope scope = this.findById(realm, null, id);
        if (scope == null) {
            return;
        }
        this.tx.delete(id);
    }

    public Scope findById(RealmModel realm, ResourceServer resourceServer, String id) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServer, StackUtil.getShortStackTrace());
        if (id == null) {
            return null;
        }
        return this.tx.read(QueryParameters.withCriteria(this.forRealmAndResourceServer(realm, resourceServer).compare(Scope.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id}))).findFirst().map(this.entityToAdapterFunc(realm, resourceServer)).orElse(null);
    }

    public Scope findByName(ResourceServer resourceServer, String name) {
        LOG.tracef("findByName(%s, %s)%s", (Object)name, (Object)resourceServer, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        return this.tx.read(QueryParameters.withCriteria(this.forRealmAndResourceServer(realm, resourceServer).compare(Scope.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name}))).findFirst().map(this.entityToAdapterFunc(realm, resourceServer)).orElse(null);
    }

    public List<Scope> findByResourceServer(ResourceServer resourceServer) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)resourceServer, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        return this.tx.read(QueryParameters.withCriteria(this.forRealmAndResourceServer(realm, resourceServer))).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    public List<Scope> findByResourceServer(ResourceServer resourceServer, Map<Scope.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
        RealmModel realm = resourceServer.getRealm();
        ModelCriteriaBuilder mcb = this.forRealmAndResourceServer(realm, resourceServer);
        block4: for (Scope.FilterOption filterOption : attributes.keySet()) {
            String[] value = attributes.get(filterOption);
            switch (filterOption) {
                case ID: {
                    mcb = mcb.compare(Scope.SearchableFields.ID, ModelCriteriaBuilder.Operator.IN, new Object[]{Arrays.asList(value)});
                    continue block4;
                }
                case NAME: {
                    mcb = mcb.compare(Scope.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + value[0] + "%"});
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported filter [" + filterOption + "]");
        }
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, (SearchableModelField<Scope>)Scope.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(Scope.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.tx.delete(QueryParameters.withCriteria(mcb));
    }

    public void preRemove(ResourceServer resourceServer) {
        LOG.tracef("preRemove(%s)%s", (Object)resourceServer, StackUtil.getShortStackTrace());
        this.tx.delete(QueryParameters.withCriteria(this.forRealmAndResourceServer(resourceServer.getRealm(), resourceServer)));
    }
}

