/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import org.keycloak.common.util.Time;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntityImpl;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapClientInitialAccessEntity
extends UpdatableEntity,
AbstractEntity {
    public static MapClientInitialAccessEntity createEntity(int expiration, int count) {
        int currentTime = Time.currentTime();
        MapClientInitialAccessEntityImpl entity = new MapClientInitialAccessEntityImpl();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setTimestamp(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(currentTime));
        entity.setExpiration(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(expiration));
        entity.setCount(count);
        entity.setRemainingCount(count);
        return entity;
    }

    public static ClientInitialAccessModel toModel(MapClientInitialAccessEntity entity) {
        if (entity == null) {
            return null;
        }
        ClientInitialAccessModel model = new ClientInitialAccessModel();
        model.setId(entity.getId());
        Long timestamp = entity.getTimestamp();
        model.setTimestamp(timestamp == null ? 0 : TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(timestamp));
        Long expiration = entity.getExpiration();
        model.setExpiration(expiration == null ? 0 : TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(expiration));
        Integer count = entity.getCount();
        model.setCount(count == null ? 0 : count);
        Integer remainingCount = entity.getRemainingCount();
        model.setRemainingCount(remainingCount == null ? 0 : remainingCount);
        return model;
    }

    public Long getTimestamp();

    public void setTimestamp(Long var1);

    public Long getExpiration();

    public void setExpiration(Long var1);

    public Integer getCount();

    public void setCount(Integer var1);

    public Integer getRemainingCount();

    public void setRemainingCount(Integer var1);
}

