/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import java.util.Collection;
import java.util.Map;

public interface EntityField<E> {
    public String getName();

    public String getNameDashed();

    public Object get(E var1);

    default public <T> void set(E e, T value) {
    }

    default public <T> void collectionAdd(E e, T value) {
        Collection c = (Collection)this.get(e);
        if (c != null) {
            c.add(value);
        }
    }

    default public <T> Object collectionRemove(E e, T value) {
        Collection c = (Collection)this.get(e);
        return c == null ? null : Boolean.valueOf(c.remove(value));
    }

    default public <K> Object mapGet(E e, K key) {
        Map m = (Map)this.get(e);
        return m == null ? null : m.get(key);
    }

    default public <K, T> void mapPut(E e, K key, T value) {
        Map m = (Map)this.get(e);
        if (m != null) {
            m.put(key, value);
        }
    }

    default public <K> Object mapRemove(E e, K key) {
        Map m = (Map)this.get(e);
        if (m != null) {
            return m.remove(key);
        }
        return null;
    }

    default public Class<?> getFieldClass() {
        return Object.class;
    }

    default public Class<?> getCollectionElementClass() {
        return Void.class;
    }

    default public Class<?> getMapKeyClass() {
        return Void.class;
    }

    default public Class<?> getMapValueClass() {
        return Void.class;
    }
}

