/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.UserManagedPermissionUtil;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.authorization.adapter.MapPermissionTicketAdapter;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class MapPermissionTicketStore
implements PermissionTicketStore {
    private static final Logger LOG = Logger.getLogger(MapPermissionTicketStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<MapPermissionTicketEntity, PermissionTicket> tx;

    public MapPermissionTicketStore(KeycloakSession session, MapStorage<MapPermissionTicketEntity, PermissionTicket> permissionTicketStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.tx = permissionTicketStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private PermissionTicket entityToAdapter(MapPermissionTicketEntity origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapPermissionTicketAdapter(origEntity, this.authorizationProvider.getStoreFactory());
    }

    private DefaultModelCriteria<PermissionTicket> forResourceServer(ResourceServer resourceServer) {
        DefaultModelCriteria<PermissionTicket> mcb = DefaultModelCriteria.criteria();
        return resourceServer == null ? mcb : mcb.compare(PermissionTicket.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resourceServer.getId()});
    }

    public long count(ResourceServer resourceServer, Map<PermissionTicket.FilterOption, String> attributes) {
        DefaultModelCriteria<PermissionTicket> mcb = this.forResourceServer(resourceServer).and((DefaultModelCriteria[])attributes.entrySet().stream().map(this::filterEntryToDefaultModelCriteria).toArray(DefaultModelCriteria[]::new));
        return this.tx.getCount(QueryParameters.withCriteria(mcb));
    }

    public PermissionTicket create(ResourceServer resourceServer, Resource resource, Scope scope, String requester) {
        LOG.tracef("create(%s, %s, %s, %s)%s", new Object[]{resource, scope, requester, resourceServer, StackUtil.getShortStackTrace()});
        String owner = this.authorizationProvider.getStoreFactory().getResourceStore().findById(resourceServer, resource.getId()).getOwner();
        ModelCriteriaBuilder mcb = ((DefaultModelCriteria)((DefaultModelCriteria)this.forResourceServer(resourceServer).compare(PermissionTicket.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{owner})).compare(PermissionTicket.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resource})).compare(PermissionTicket.SearchableFields.REQUESTER, ModelCriteriaBuilder.Operator.EQ, new Object[]{requester});
        if (scope != null) {
            mcb = ((DefaultModelCriteria)mcb).compare(PermissionTicket.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{scope.getId()});
        }
        if (this.tx.getCount(QueryParameters.withCriteria(mcb)) > 0L) {
            throw new ModelDuplicateException("Permission ticket for resource server: '" + resourceServer.getId() + ", Resource: " + resource + ", owner: " + owner + ", scopeId: " + scope + " already exists.");
        }
        MapPermissionTicketEntity entity = new MapPermissionTicketEntityImpl();
        entity.setResourceId(resource.getId());
        entity.setRequester(requester);
        entity.setCreatedTimestamp(Time.currentTimeMillis());
        if (scope != null) {
            entity.setScopeId(scope.getId());
        }
        entity.setOwner(owner);
        entity.setResourceServerId(resourceServer.getId());
        entity = this.tx.create(entity);
        return this.entityToAdapter(entity);
    }

    public void delete(String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        PermissionTicket permissionTicket = this.findById(null, id);
        if (permissionTicket == null) {
            return;
        }
        this.tx.delete(id);
        UserManagedPermissionUtil.removePolicy((PermissionTicket)permissionTicket, (StoreFactory)this.authorizationProvider.getStoreFactory());
    }

    public PermissionTicket findById(ResourceServer resourceServer, String id) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(PermissionTicket.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id}))).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public List<PermissionTicket> findByResourceServer(ResourceServer resourceServer) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<PermissionTicket> findByOwner(ResourceServer resourceServer, String owner) {
        LOG.tracef("findByOwner(%s, %s)%s", (Object)owner, (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(PermissionTicket.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{owner}))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<PermissionTicket> findByResource(ResourceServer resourceServer, Resource resource) {
        LOG.tracef("findByResource(%s, %s)%s", (Object)resource, (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(PermissionTicket.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resource.getId()}))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<PermissionTicket> findByScope(ResourceServer resourceServer, Scope scope) {
        LOG.tracef("findByScope(%s, %s)%s", (Object)scope, (Object)resourceServer, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServer).compare(PermissionTicket.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{scope.getId()}))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<PermissionTicket> find(ResourceServer resourceServer, Map<PermissionTicket.FilterOption, String> attributes, Integer firstResult, Integer maxResult) {
        ModelCriteriaBuilder mcb = this.forResourceServer(resourceServer);
        if (attributes.containsKey(PermissionTicket.FilterOption.RESOURCE_NAME)) {
            String expectedResourceName = attributes.remove(PermissionTicket.FilterOption.RESOURCE_NAME);
            EnumMap<Resource.FilterOption, String[]> filterOptionStringMap = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
            filterOptionStringMap.put(Resource.FilterOption.EXACT_NAME, new String[]{expectedResourceName});
            List r = this.authorizationProvider.getStoreFactory().getResourceStore().findByResourceServer(resourceServer, filterOptionStringMap, null, null);
            if (r == null || r.isEmpty()) {
                return Collections.emptyList();
            }
            mcb = mcb.compare(PermissionTicket.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.IN, new Object[]{r.stream().map(Resource::getId)});
        }
        mcb = mcb.and((DefaultModelCriteria[])attributes.entrySet().stream().map(this::filterEntryToDefaultModelCriteria).toArray(DefaultModelCriteria[]::new));
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResult, (SearchableModelField<PermissionTicket>)PermissionTicket.SearchableFields.ID)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    private DefaultModelCriteria<PermissionTicket> filterEntryToDefaultModelCriteria(Map.Entry<PermissionTicket.FilterOption, String> entry) {
        PermissionTicket.FilterOption name = entry.getKey();
        String value = entry.getValue();
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        switch (name) {
            case ID: 
            case SCOPE_ID: 
            case RESOURCE_ID: 
            case OWNER: 
            case REQUESTER: 
            case POLICY_ID: {
                return mcb.compare(name.getSearchableModelField(), ModelCriteriaBuilder.Operator.EQ, new Object[]{value});
            }
            case SCOPE_IS_NULL: 
            case GRANTED: 
            case REQUESTER_IS_NULL: {
                ModelCriteriaBuilder.Operator op = ModelCriteriaBuilder.Operator.NOT_EXISTS;
                if (Boolean.parseBoolean(value)) {
                    op = ModelCriteriaBuilder.Operator.EXISTS;
                }
                return mcb.compare(name.getSearchableModelField(), op, new Object[0]);
            }
            case POLICY_IS_NOT_NULL: {
                return mcb.compare(PermissionTicket.SearchableFields.REQUESTER, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported filter [" + name + "]");
    }

    public List<PermissionTicket> findGranted(ResourceServer resourceServer, String userId) {
        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
        filters.put(PermissionTicket.FilterOption.REQUESTER, userId);
        return this.find(resourceServer, filters, null, null);
    }

    public List<PermissionTicket> findGranted(ResourceServer resourceServer, String resourceName, String userId) {
        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        filters.put(PermissionTicket.FilterOption.RESOURCE_NAME, resourceName);
        filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
        filters.put(PermissionTicket.FilterOption.REQUESTER, userId);
        return this.find(resourceServer, filters, null, null);
    }

    public List<Resource> findGrantedResources(String requester, String name, Integer first, Integer max) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(PermissionTicket.SearchableFields.REQUESTER, ModelCriteriaBuilder.Operator.EQ, new Object[]{requester})).compare(PermissionTicket.SearchableFields.GRANTED_TIMESTAMP, ModelCriteriaBuilder.Operator.EXISTS, new Object[0]);
        ResourceStore resourceStore = this.authorizationProvider.getStoreFactory().getResourceStore();
        ResourceServerStore resourceServerStore = this.authorizationProvider.getStoreFactory().getResourceServerStore();
        Function<MapPermissionTicketEntity, Resource> ticketResourceMapper = name != null ? ticket -> {
            EnumMap<Resource.FilterOption, String[]> filterOptionMap = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
            filterOptionMap.put(Resource.FilterOption.ID, new String[]{ticket.getResourceId()});
            filterOptionMap.put(Resource.FilterOption.NAME, new String[]{name});
            List resource = resourceStore.findByResourceServer(resourceServerStore.findById(ticket.getResourceServerId()), filterOptionMap, Integer.valueOf(-1), Integer.valueOf(1));
            return resource.isEmpty() ? null : (Resource)resource.get(0);
        } : ticket -> resourceStore.findById(resourceServerStore.findById(ticket.getResourceServerId()), ticket.getResourceId());
        return StreamsUtil.paginatedStream(this.tx.read(QueryParameters.withCriteria(mcb).orderBy(PermissionTicket.SearchableFields.RESOURCE_ID, QueryParameters.Order.ASCENDING)).filter(StreamsUtil.distinctByKey(MapPermissionTicketEntity::getResourceId)).map(ticketResourceMapper).filter(Objects::nonNull), (Integer)first, (Integer)max).collect(Collectors.toList());
    }

    public List<Resource> findGrantedOwnerResources(String owner, Integer firstResult, Integer maxResults) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(PermissionTicket.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{owner});
        ResourceStore resourceStore = this.authorizationProvider.getStoreFactory().getResourceStore();
        ResourceServerStore resourceServerStore = this.authorizationProvider.getStoreFactory().getResourceServerStore();
        return StreamsUtil.paginatedStream(this.tx.read(QueryParameters.withCriteria(mcb).orderBy(PermissionTicket.SearchableFields.RESOURCE_ID, QueryParameters.Order.ASCENDING)).filter(StreamsUtil.distinctByKey(MapPermissionTicketEntity::getResourceId)), (Integer)firstResult, (Integer)maxResults).map(ticket -> resourceStore.findById(resourceServerStore.findById(ticket.getResourceServerId()), ticket.getResourceId())).collect(Collectors.toList());
    }
}

