/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityWithAttributes;
import org.keycloak.models.map.common.UpdatableEntity;

@DeepCloner.Root
public interface MapClientEntity
extends AbstractEntity,
UpdatableEntity,
EntityWithAttributes {
    public Map<String, Boolean> getClientScopes();

    public Stream<String> getClientScopes(boolean var1);

    public void setClientScope(String var1, Boolean var2);

    public void removeClientScope(String var1);

    public MapProtocolMapperEntity getProtocolMapper(String var1);

    public Map<String, MapProtocolMapperEntity> getProtocolMappers();

    public void setProtocolMapper(String var1, MapProtocolMapperEntity var2);

    public void removeProtocolMapper(String var1);

    public void addRedirectUri(String var1);

    public Set<String> getRedirectUris();

    public void removeRedirectUri(String var1);

    public void setRedirectUris(Set<String> var1);

    public void addScopeMapping(String var1);

    public void removeScopeMapping(String var1);

    public Collection<String> getScopeMappings();

    public void addWebOrigin(String var1);

    public Set<String> getWebOrigins();

    public void removeWebOrigin(String var1);

    public void setWebOrigins(Set<String> var1);

    public String getAuthenticationFlowBindingOverride(String var1);

    public Map<String, String> getAuthenticationFlowBindingOverrides();

    public void removeAuthenticationFlowBindingOverride(String var1);

    public void setAuthenticationFlowBindingOverride(String var1, String var2);

    public String getBaseUrl();

    public String getClientAuthenticatorType();

    public String getClientId();

    public String getDescription();

    public String getManagementUrl();

    public String getName();

    public Integer getNodeReRegistrationTimeout();

    public Long getNotBefore();

    public String getProtocol();

    public String getRealmId();

    public String getRegistrationToken();

    public String getRootUrl();

    public Set<String> getScope();

    public String getSecret();

    public Boolean isAlwaysDisplayInConsole();

    public Boolean isBearerOnly();

    public Boolean isConsentRequired();

    public Boolean isDirectAccessGrantsEnabled();

    public Boolean isEnabled();

    public Boolean isFrontchannelLogout();

    public Boolean isFullScopeAllowed();

    public Boolean isImplicitFlowEnabled();

    public Boolean isPublicClient();

    public Boolean isServiceAccountsEnabled();

    public Boolean isStandardFlowEnabled();

    public Boolean isSurrogateAuthRequired();

    public void setAlwaysDisplayInConsole(Boolean var1);

    public void setBaseUrl(String var1);

    public void setBearerOnly(Boolean var1);

    public void setClientAuthenticatorType(String var1);

    public void setClientId(String var1);

    public void setConsentRequired(Boolean var1);

    public void setDescription(String var1);

    public void setDirectAccessGrantsEnabled(Boolean var1);

    public void setEnabled(Boolean var1);

    public void setFrontchannelLogout(Boolean var1);

    public void setFullScopeAllowed(Boolean var1);

    public void setImplicitFlowEnabled(Boolean var1);

    public void setManagementUrl(String var1);

    public void setName(String var1);

    public void setNodeReRegistrationTimeout(Integer var1);

    public void setNotBefore(Long var1);

    public void setProtocol(String var1);

    public void setPublicClient(Boolean var1);

    public void setRealmId(String var1);

    public void setRegistrationToken(String var1);

    public void setRootUrl(String var1);

    public void setScope(Set<String> var1);

    public void setSecret(String var1);

    public void setServiceAccountsEnabled(Boolean var1);

    public void setStandardFlowEnabled(Boolean var1);

    public void setSurrogateAuthRequired(Boolean var1);

    public static abstract class AbstractClientEntity
    extends UpdatableEntity.Impl
    implements MapClientEntity {
        private String id;

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            if (this.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            this.id = id;
            this.updated |= id != null;
        }

        @Override
        public boolean isUpdated() {
            return this.updated || Optional.ofNullable(this.getProtocolMappers()).orElseGet(Collections::emptyMap).values().stream().anyMatch(UpdatableEntity::isUpdated);
        }

        @Override
        public void clearUpdatedFlag() {
            this.updated = false;
            Optional.ofNullable(this.getProtocolMappers()).orElseGet(Collections::emptyMap).values().forEach(UpdatableEntity::clearUpdatedFlag);
        }

        @Override
        public Stream<String> getClientScopes(boolean defaultScope) {
            Map<String, Boolean> clientScopes = this.getClientScopes();
            return clientScopes == null ? Stream.empty() : clientScopes.entrySet().stream().filter(me -> Objects.equals(me.getValue(), defaultScope)).map(Map.Entry::getKey);
        }
    }
}

