/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import java.util.Collections;
import java.util.Map;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.userSession.AbstractAuthenticatedClientSessionModel;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;

public abstract class MapAuthenticatedClientSessionAdapter
extends AbstractAuthenticatedClientSessionModel {
    public MapAuthenticatedClientSessionAdapter(KeycloakSession session, RealmModel realm, ClientModel client, UserSessionModel userSession, MapAuthenticatedClientSessionEntity entity) {
        super(session, realm, client, userSession, entity);
    }

    public String getId() {
        return this.entity.getId();
    }

    public int getTimestamp() {
        Long timestamp = this.entity.getTimestamp();
        return timestamp != null ? TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(timestamp) : 0;
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(timestamp));
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public String getCurrentRefreshToken() {
        return this.entity.getCurrentRefreshToken();
    }

    public void setCurrentRefreshToken(String currentRefreshToken) {
        this.entity.setCurrentRefreshToken(currentRefreshToken);
    }

    public int getCurrentRefreshTokenUseCount() {
        Integer currentRefreshTokenUseCount = this.entity.getCurrentRefreshTokenUseCount();
        return currentRefreshTokenUseCount != null ? currentRefreshTokenUseCount : 0;
    }

    public void setCurrentRefreshTokenUseCount(int currentRefreshTokenUseCount) {
        this.entity.setCurrentRefreshTokenUseCount(currentRefreshTokenUseCount);
    }

    public String getNote(String name) {
        return name != null ? this.entity.getNote(name) : null;
    }

    public void setNote(String name, String value) {
        if (name != null) {
            if (value == null) {
                this.entity.removeNote(name);
            } else {
                this.entity.setNote(name, value);
            }
        }
    }

    public void removeNote(String name) {
        if (name != null) {
            this.entity.removeNote(name);
        }
    }

    public Map<String, String> getNotes() {
        Map<String, String> notes = this.entity.getNotes();
        return notes == null ? Collections.emptyMap() : Collections.unmodifiableMap(notes);
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public void setRedirectUri(String uri) {
        this.entity.setRedirectUri(uri);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public String getAction() {
        return this.entity.getAction();
    }

    public void setAction(String action) {
        this.entity.setAction(action);
    }

    public String getProtocol() {
        return this.entity.getAuthMethod();
    }

    public void setProtocol(String method) {
        this.entity.setAuthMethod(method);
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }
}

