/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.criteria;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.ModelCriteriaNode;
import org.keycloak.storage.SearchableModelField;

public class DefaultModelCriteria<M>
implements ModelCriteriaBuilder<M, DefaultModelCriteria<M>> {
    private static final DefaultModelCriteria<?> INSTANCE = new DefaultModelCriteria(null);
    private final ModelCriteriaNode<M> node;

    private DefaultModelCriteria(ModelCriteriaNode<M> node) {
        this.node = node;
    }

    public static <M> DefaultModelCriteria<M> criteria() {
        return INSTANCE;
    }

    @Override
    public DefaultModelCriteria<M> compare(SearchableModelField<? super M> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        return this.compare(new ModelCriteriaNode<M>(modelField, op, value));
    }

    private DefaultModelCriteria<M> compare(ModelCriteriaNode<M> nodeToAdd) {
        ModelCriteriaNode<M> targetNode;
        if (this.isEmpty()) {
            targetNode = nodeToAdd;
        } else if (this.node.getNodeOperator() == ModelCriteriaNode.ExtOperator.AND) {
            targetNode = this.node.cloneTree();
            targetNode.addChild(nodeToAdd);
        } else {
            targetNode = new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.AND);
            targetNode.addChild(this.node.cloneTree());
            targetNode.addChild(nodeToAdd);
        }
        return new DefaultModelCriteria<M>(targetNode);
    }

    public DefaultModelCriteria<M> and(DefaultModelCriteria<M> ... mcbs) {
        if (mcbs.length == 1) {
            return this.compare(mcbs[0].node);
        }
        ModelCriteriaNode targetNode = new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.AND);
        AtomicBoolean hasFalseNode = new AtomicBoolean(false);
        for (DefaultModelCriteria<M> mcb : mcbs) {
            ModelCriteriaNode<M> nodeToAdd = mcb.node;
            this.getNodesToAddForAndOr(nodeToAdd, ModelCriteriaNode.ExtOperator.AND).filter(ModelCriteriaNode::isNotTrueNode).peek(n -> {
                if (n.isFalseNode()) {
                    hasFalseNode.lazySet(true);
                }
            }).map(ModelCriteriaNode::cloneTree).forEach(targetNode::addChild);
            if (!hasFalseNode.get()) continue;
            return this.compare(new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__FALSE__));
        }
        if (targetNode.getChildren().isEmpty()) {
            return this.compare(new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__TRUE__));
        }
        return this.compare(targetNode);
    }

    public DefaultModelCriteria<M> or(DefaultModelCriteria<M> ... mcbs) {
        if (mcbs.length == 1) {
            return this.compare(mcbs[0].node);
        }
        ModelCriteriaNode targetNode = new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.OR);
        AtomicBoolean hasTrueNode = new AtomicBoolean(false);
        for (DefaultModelCriteria<M> mcb : mcbs) {
            ModelCriteriaNode<M> nodeToAdd = mcb.node;
            this.getNodesToAddForAndOr(nodeToAdd, ModelCriteriaNode.ExtOperator.OR).filter(ModelCriteriaNode::isNotFalseNode).peek(n -> {
                if (n.isTrueNode()) {
                    hasTrueNode.lazySet(true);
                }
            }).map(ModelCriteriaNode::cloneTree).forEach(targetNode::addChild);
            if (!hasTrueNode.get()) continue;
            return this.compare(new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__TRUE__));
        }
        if (targetNode.getChildren().isEmpty()) {
            return this.compare(new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.__FALSE__));
        }
        return this.compare(targetNode);
    }

    @Override
    public DefaultModelCriteria<M> not(DefaultModelCriteria<M> mcb) {
        ModelCriteriaNode<M> toBeChild = mcb.node;
        if (toBeChild.getNodeOperator() == ModelCriteriaNode.ExtOperator.NOT) {
            return this.compare(((ModelCriteriaNode)toBeChild.getChildren().get(0)).cloneTree());
        }
        ModelCriteriaNode targetNode = new ModelCriteriaNode(ModelCriteriaNode.ExtOperator.NOT);
        targetNode.addChild(toBeChild.cloneTree());
        return this.compare(targetNode);
    }

    public <C extends ModelCriteriaBuilder<M, C>> C flashToModelCriteriaBuilder(C mcb) {
        if (this.isEmpty()) {
            return mcb;
        }
        return mcb == null ? null : (C)this.node.flashToModelCriteriaBuilder(mcb);
    }

    public DefaultModelCriteria<M> optimize() {
        return this.flashToModelCriteriaBuilder(DefaultModelCriteria.criteria());
    }

    public DefaultModelCriteria<M> partiallyEvaluate(AtomicFormulaTester<M> tester) {
        return new DefaultModelCriteria<M>(this.node.cloneTree((field, operator, operatorArguments) -> {
            Boolean res = tester.test(field, operator, operatorArguments);
            if (res == null) {
                return new ModelCriteriaNode(field, operator, operatorArguments);
            }
            return new ModelCriteriaNode(res != false ? ModelCriteriaNode.ExtOperator.__TRUE__ : ModelCriteriaNode.ExtOperator.__FALSE__);
        }, ModelCriteriaNode::new));
    }

    public boolean isEmpty() {
        return this.node == null;
    }

    public String toString() {
        return this.isEmpty() ? "" : this.node.toString();
    }

    private Stream<ModelCriteriaNode<M>> getNodesToAddForAndOr(ModelCriteriaNode<M> nodeToAdd, ModelCriteriaNode.ExtOperator operatorBeingAdded) {
        ModelCriteriaNode.ExtOperator op = nodeToAdd.getNodeOperator();
        if (op == operatorBeingAdded) {
            return nodeToAdd.getChildren().stream();
        }
        return Stream.of(nodeToAdd);
    }

    @FunctionalInterface
    public static interface AtomicFormulaTester<M> {
        public Boolean test(SearchableModelField<? super M> var1, ModelCriteriaBuilder.Operator var2, Object[] var3);
    }
}

