/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;

public class MapRealmEntityImpl
extends MapRealmEntity.AbstractRealmEntity
implements MapRealmEntity {
    private final DeepCloner cloner;
    private String fId;
    private Integer fAccessCodeLifespan;
    private Integer fAccessCodeLifespanLogin;
    private Integer fAccessCodeLifespanUserAction;
    private Integer fAccessTokenLifespan;
    private Integer fAccessTokenLifespanForImplicitFlow;
    private String fAccountTheme;
    private Integer fActionTokenGeneratedByAdminLifespan;
    private Boolean fAdminEventsDetailsEnabled;
    private Boolean fAdminEventsEnabled;
    private String fAdminTheme;
    private Boolean fAllowUserManagedAccess;
    private Map<String, List<String>> fAttributes;
    private Set<MapAuthenticationExecutionEntity> fAuthenticationExecutions;
    private Set<MapAuthenticationFlowEntity> fAuthenticationFlows;
    private Set<MapAuthenticatorConfigEntity> fAuthenticatorConfigs;
    private String fBrowserFlow;
    private Map<String, String> fBrowserSecurityHeaders;
    private String fClientAuthenticationFlow;
    private Set<MapClientInitialAccessEntity> fClientInitialAccesses;
    private Integer fClientOfflineSessionIdleTimeout;
    private Integer fClientOfflineSessionMaxLifespan;
    private Integer fClientSessionIdleTimeout;
    private Integer fClientSessionMaxLifespan;
    private Set<MapComponentEntity> fComponents;
    private Set<String> fDefaultClientScopeIds;
    private Set<String> fDefaultGroupIds;
    private String fDefaultLocale;
    private String fDefaultRoleId;
    private String fDirectGrantFlow;
    private String fDisplayName;
    private String fDisplayNameHtml;
    private String fDockerAuthenticationFlow;
    private Boolean fDuplicateEmailsAllowed;
    private Boolean fEditUsernameAllowed;
    private String fEmailTheme;
    private Boolean fEnabled;
    private Set<String> fEnabledEventTypes;
    private Boolean fEventsEnabled;
    private Long fEventsExpiration;
    private Set<String> fEventsListeners;
    private Set<MapIdentityProviderMapperEntity> fIdentityProviderMappers;
    private Set<MapIdentityProviderEntity> fIdentityProviders;
    private Boolean fInternationalizationEnabled;
    private Map<String, Map<String, String>> fLocalizationTexts;
    private String fLoginTheme;
    private Boolean fLoginWithEmailAllowed;
    private String fMasterAdminClient;
    private String fName;
    private Long fNotBefore;
    private MapOTPPolicyEntity fOTPPolicy;
    private Integer fOfflineSessionIdleTimeout;
    private Integer fOfflineSessionMaxLifespan;
    private Boolean fOfflineSessionMaxLifespanEnabled;
    private Set<String> fOptionalClientScopeIds;
    private String fPasswordPolicy;
    private Integer fRefreshTokenMaxReuse;
    private Boolean fRegistrationAllowed;
    private Boolean fRegistrationEmailAsUsername;
    private String fRegistrationFlow;
    private Boolean fRememberMe;
    private Set<MapRequiredActionProviderEntity> fRequiredActionProviders;
    private Set<MapRequiredCredentialEntity> fRequiredCredentials;
    private String fResetCredentialsFlow;
    private Boolean fResetPasswordAllowed;
    private Boolean fRevokeRefreshToken;
    private Map<String, String> fSmtpConfig;
    private String fSslRequired;
    private Integer fSsoSessionIdleTimeout;
    private Integer fSsoSessionIdleTimeoutRememberMe;
    private Integer fSsoSessionMaxLifespan;
    private Integer fSsoSessionMaxLifespanRememberMe;
    private Set<String> fSupportedLocales;
    private Boolean fVerifyEmail;
    private MapWebAuthnPolicyEntity fWebAuthnPolicy;
    private MapWebAuthnPolicyEntity fWebAuthnPolicyPasswordless;

    public MapRealmEntityImpl() {
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public MapRealmEntityImpl(DeepCloner cloner) {
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapRealmEntityImpl)) {
            return false;
        }
        MapRealmEntityImpl other = (MapRealmEntityImpl)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAccessCodeLifespan(), other.getAccessCodeLifespan()) && Objects.equals(this.getAccessCodeLifespanLogin(), other.getAccessCodeLifespanLogin()) && Objects.equals(this.getAccessCodeLifespanUserAction(), other.getAccessCodeLifespanUserAction()) && Objects.equals(this.getAccessTokenLifespan(), other.getAccessTokenLifespan()) && Objects.equals(this.getAccessTokenLifespanForImplicitFlow(), other.getAccessTokenLifespanForImplicitFlow()) && Objects.equals(this.getAccountTheme(), other.getAccountTheme()) && Objects.equals(this.getActionTokenGeneratedByAdminLifespan(), other.getActionTokenGeneratedByAdminLifespan()) && Objects.equals(this.getAdminTheme(), other.getAdminTheme()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getAuthenticationExecutions(), other.getAuthenticationExecutions()) && Objects.equals(this.getAuthenticationFlows(), other.getAuthenticationFlows()) && Objects.equals(this.getAuthenticatorConfigs(), other.getAuthenticatorConfigs()) && Objects.equals(this.getBrowserFlow(), other.getBrowserFlow()) && Objects.equals(this.getBrowserSecurityHeaders(), other.getBrowserSecurityHeaders()) && Objects.equals(this.getClientAuthenticationFlow(), other.getClientAuthenticationFlow()) && Objects.equals(this.getClientInitialAccesses(), other.getClientInitialAccesses()) && Objects.equals(this.getClientOfflineSessionIdleTimeout(), other.getClientOfflineSessionIdleTimeout()) && Objects.equals(this.getClientOfflineSessionMaxLifespan(), other.getClientOfflineSessionMaxLifespan()) && Objects.equals(this.getClientSessionIdleTimeout(), other.getClientSessionIdleTimeout()) && Objects.equals(this.getClientSessionMaxLifespan(), other.getClientSessionMaxLifespan()) && Objects.equals(this.getComponents(), other.getComponents()) && Objects.equals(this.getDefaultClientScopeIds(), other.getDefaultClientScopeIds()) && Objects.equals(this.getDefaultGroupIds(), other.getDefaultGroupIds()) && Objects.equals(this.getDefaultLocale(), other.getDefaultLocale()) && Objects.equals(this.getDefaultRoleId(), other.getDefaultRoleId()) && Objects.equals(this.getDirectGrantFlow(), other.getDirectGrantFlow()) && Objects.equals(this.getDisplayName(), other.getDisplayName()) && Objects.equals(this.getDisplayNameHtml(), other.getDisplayNameHtml()) && Objects.equals(this.getDockerAuthenticationFlow(), other.getDockerAuthenticationFlow()) && Objects.equals(this.getEmailTheme(), other.getEmailTheme()) && Objects.equals(this.getEnabledEventTypes(), other.getEnabledEventTypes()) && Objects.equals(this.getEventsExpiration(), other.getEventsExpiration()) && Objects.equals(this.getEventsListeners(), other.getEventsListeners()) && Objects.equals(this.getIdentityProviderMappers(), other.getIdentityProviderMappers()) && Objects.equals(this.getIdentityProviders(), other.getIdentityProviders()) && Objects.equals(this.getLocalizationTexts(), other.getLocalizationTexts()) && Objects.equals(this.getLoginTheme(), other.getLoginTheme()) && Objects.equals(this.getMasterAdminClient(), other.getMasterAdminClient()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getNotBefore(), other.getNotBefore()) && Objects.equals(this.getOTPPolicy(), other.getOTPPolicy()) && Objects.equals(this.getOfflineSessionIdleTimeout(), other.getOfflineSessionIdleTimeout()) && Objects.equals(this.getOfflineSessionMaxLifespan(), other.getOfflineSessionMaxLifespan()) && Objects.equals(this.getOptionalClientScopeIds(), other.getOptionalClientScopeIds()) && Objects.equals(this.getPasswordPolicy(), other.getPasswordPolicy()) && Objects.equals(this.getRefreshTokenMaxReuse(), other.getRefreshTokenMaxReuse()) && Objects.equals(this.getRegistrationFlow(), other.getRegistrationFlow()) && Objects.equals(this.getRequiredActionProviders(), other.getRequiredActionProviders()) && Objects.equals(this.getRequiredCredentials(), other.getRequiredCredentials()) && Objects.equals(this.getResetCredentialsFlow(), other.getResetCredentialsFlow()) && Objects.equals(this.getSmtpConfig(), other.getSmtpConfig()) && Objects.equals(this.getSslRequired(), other.getSslRequired()) && Objects.equals(this.getSsoSessionIdleTimeout(), other.getSsoSessionIdleTimeout()) && Objects.equals(this.getSsoSessionIdleTimeoutRememberMe(), other.getSsoSessionIdleTimeoutRememberMe()) && Objects.equals(this.getSsoSessionMaxLifespan(), other.getSsoSessionMaxLifespan()) && Objects.equals(this.getSsoSessionMaxLifespanRememberMe(), other.getSsoSessionMaxLifespanRememberMe()) && Objects.equals(this.getSupportedLocales(), other.getSupportedLocales()) && Objects.equals(this.getWebAuthnPolicy(), other.getWebAuthnPolicy()) && Objects.equals(this.getWebAuthnPolicyPasswordless(), other.getWebAuthnPolicyPasswordless()) && Objects.equals(this.isAdminEventsDetailsEnabled(), other.isAdminEventsDetailsEnabled()) && Objects.equals(this.isAdminEventsEnabled(), other.isAdminEventsEnabled()) && Objects.equals(this.isAllowUserManagedAccess(), other.isAllowUserManagedAccess()) && Objects.equals(this.isDuplicateEmailsAllowed(), other.isDuplicateEmailsAllowed()) && Objects.equals(this.isEditUsernameAllowed(), other.isEditUsernameAllowed()) && Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.isEventsEnabled(), other.isEventsEnabled()) && Objects.equals(this.isInternationalizationEnabled(), other.isInternationalizationEnabled()) && Objects.equals(this.isLoginWithEmailAllowed(), other.isLoginWithEmailAllowed()) && Objects.equals(this.isOfflineSessionMaxLifespanEnabled(), other.isOfflineSessionMaxLifespanEnabled()) && Objects.equals(this.isRegistrationAllowed(), other.isRegistrationAllowed()) && Objects.equals(this.isRegistrationEmailAsUsername(), other.isRegistrationEmailAsUsername()) && Objects.equals(this.isRememberMe(), other.isRememberMe()) && Objects.equals(this.isResetPasswordAllowed(), other.isResetPasswordAllowed()) && Objects.equals(this.isRevokeRefreshToken(), other.isRevokeRefreshToken()) && Objects.equals(this.isVerifyEmail(), other.isVerifyEmail());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public <V> V deepClone(V obj) {
        return this.cloner.from(obj);
    }

    @Override
    public void setAccessCodeLifespan(Integer p0) {
        this.updated |= !Objects.equals(this.fAccessCodeLifespan, p0);
        this.fAccessCodeLifespan = p0;
    }

    @Override
    public Integer getAccessCodeLifespan() {
        return this.fAccessCodeLifespan;
    }

    @Override
    public Integer getAccessCodeLifespanLogin() {
        return this.fAccessCodeLifespanLogin;
    }

    @Override
    public void setAccessCodeLifespanLogin(Integer p0) {
        this.updated |= !Objects.equals(this.fAccessCodeLifespanLogin, p0);
        this.fAccessCodeLifespanLogin = p0;
    }

    @Override
    public Integer getAccessCodeLifespanUserAction() {
        return this.fAccessCodeLifespanUserAction;
    }

    @Override
    public void setAccessCodeLifespanUserAction(Integer p0) {
        this.updated |= !Objects.equals(this.fAccessCodeLifespanUserAction, p0);
        this.fAccessCodeLifespanUserAction = p0;
    }

    @Override
    public void setAccessTokenLifespan(Integer p0) {
        this.updated |= !Objects.equals(this.fAccessTokenLifespan, p0);
        this.fAccessTokenLifespan = p0;
    }

    @Override
    public Integer getAccessTokenLifespan() {
        return this.fAccessTokenLifespan;
    }

    @Override
    public Integer getAccessTokenLifespanForImplicitFlow() {
        return this.fAccessTokenLifespanForImplicitFlow;
    }

    @Override
    public void setAccessTokenLifespanForImplicitFlow(Integer p0) {
        this.updated |= !Objects.equals(this.fAccessTokenLifespanForImplicitFlow, p0);
        this.fAccessTokenLifespanForImplicitFlow = p0;
    }

    @Override
    public void setAccountTheme(String p0) {
        this.updated |= !Objects.equals(this.fAccountTheme, p0);
        this.fAccountTheme = p0;
    }

    @Override
    public String getAccountTheme() {
        return this.fAccountTheme;
    }

    @Override
    public void setActionTokenGeneratedByAdminLifespan(Integer p0) {
        this.updated |= !Objects.equals(this.fActionTokenGeneratedByAdminLifespan, p0);
        this.fActionTokenGeneratedByAdminLifespan = p0;
    }

    @Override
    public Integer getActionTokenGeneratedByAdminLifespan() {
        return this.fActionTokenGeneratedByAdminLifespan;
    }

    @Override
    public void setAdminEventsDetailsEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fAdminEventsDetailsEnabled, p0);
        this.fAdminEventsDetailsEnabled = p0;
    }

    @Override
    public Boolean isAdminEventsDetailsEnabled() {
        return this.fAdminEventsDetailsEnabled;
    }

    @Override
    public void setAdminEventsEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fAdminEventsEnabled, p0);
        this.fAdminEventsEnabled = p0;
    }

    @Override
    public Boolean isAdminEventsEnabled() {
        return this.fAdminEventsEnabled;
    }

    @Override
    public void setAdminTheme(String p0) {
        this.updated |= !Objects.equals(this.fAdminTheme, p0);
        this.fAdminTheme = p0;
    }

    @Override
    public String getAdminTheme() {
        return this.fAdminTheme;
    }

    @Override
    public Boolean isAllowUserManagedAccess() {
        return this.fAllowUserManagedAccess;
    }

    @Override
    public void setAllowUserManagedAccess(Boolean p0) {
        this.updated |= !Objects.equals(this.fAllowUserManagedAccess, p0);
        this.fAllowUserManagedAccess = p0;
    }

    @Override
    public void setAttribute(String p0, List<String> p1) {
        LinkedList v;
        boolean valueUndefined;
        LinkedList<String> linkedList = p1 = p1 == null ? null : new LinkedList<String>(p1);
        if (p1 != null) {
            p1.removeIf(UndefinedValuesUtils::isUndefined);
        }
        if (valueUndefined = UndefinedValuesUtils.isUndefined(p1)) {
            if (this.fAttributes != null) {
                this.updated |= this.fAttributes.remove(p0) != null;
            }
            return;
        }
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, List<String>>();
        }
        this.updated |= !Objects.equals(v = this.fAttributes.put(p0, p1), p1);
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.fAttributes;
    }

    @Override
    public void setAttributes(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fAttributes, p0);
        this.fAttributes = p0;
    }

    @Override
    public List<String> getAttribute(String p0) {
        return this.fAttributes == null ? null : this.fAttributes.get(p0);
    }

    @Override
    public void removeAttribute(String p0) {
        if (this.fAttributes == null) {
            return;
        }
        boolean removed = this.fAttributes.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public void addAuthenticationExecution(MapAuthenticationExecutionEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fAuthenticationExecutions == null) {
            this.fAuthenticationExecutions = new HashSet<MapAuthenticationExecutionEntity>();
        }
        this.updated |= this.fAuthenticationExecutions.add(p0);
    }

    @Override
    public Set<MapAuthenticationExecutionEntity> getAuthenticationExecutions() {
        return this.fAuthenticationExecutions;
    }

    @Override
    public void addAuthenticationFlow(MapAuthenticationFlowEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fAuthenticationFlows == null) {
            this.fAuthenticationFlows = new HashSet<MapAuthenticationFlowEntity>();
        }
        this.updated |= this.fAuthenticationFlows.add(p0);
    }

    @Override
    public Set<MapAuthenticationFlowEntity> getAuthenticationFlows() {
        return this.fAuthenticationFlows;
    }

    @Override
    public void addAuthenticatorConfig(MapAuthenticatorConfigEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fAuthenticatorConfigs == null) {
            this.fAuthenticatorConfigs = new HashSet<MapAuthenticatorConfigEntity>();
        }
        this.updated |= this.fAuthenticatorConfigs.add(p0);
    }

    @Override
    public Set<MapAuthenticatorConfigEntity> getAuthenticatorConfigs() {
        return this.fAuthenticatorConfigs;
    }

    @Override
    public void setBrowserFlow(String p0) {
        this.updated |= !Objects.equals(this.fBrowserFlow, p0);
        this.fBrowserFlow = p0;
    }

    @Override
    public String getBrowserFlow() {
        return this.fBrowserFlow;
    }

    @Override
    public void setBrowserSecurityHeader(String p0, String p1) {
        String v;
        boolean valueUndefined = UndefinedValuesUtils.isUndefined(p1);
        if (valueUndefined) {
            if (this.fBrowserSecurityHeaders != null) {
                this.updated |= this.fBrowserSecurityHeaders.remove(p0) != null;
            }
            return;
        }
        if (this.fBrowserSecurityHeaders == null) {
            this.fBrowserSecurityHeaders = new HashMap<String, String>();
        }
        this.updated |= !Objects.equals(v = this.fBrowserSecurityHeaders.put(p0, p1), p1);
    }

    @Override
    public void setBrowserSecurityHeaders(Map<String, String> p0) {
        HashMap<String, String> hashMap = p0 = p0 == null ? null : new HashMap<String, String>(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fBrowserSecurityHeaders, p0);
        this.fBrowserSecurityHeaders = p0;
    }

    @Override
    public Map<String, String> getBrowserSecurityHeaders() {
        return this.fBrowserSecurityHeaders;
    }

    @Override
    public void setClientAuthenticationFlow(String p0) {
        this.updated |= !Objects.equals(this.fClientAuthenticationFlow, p0);
        this.fClientAuthenticationFlow = p0;
    }

    @Override
    public String getClientAuthenticationFlow() {
        return this.fClientAuthenticationFlow;
    }

    @Override
    public void addClientInitialAccess(MapClientInitialAccessEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fClientInitialAccesses == null) {
            this.fClientInitialAccesses = new HashSet<MapClientInitialAccessEntity>();
        }
        this.updated |= this.fClientInitialAccesses.add(p0);
    }

    @Override
    public Set<MapClientInitialAccessEntity> getClientInitialAccesses() {
        return this.fClientInitialAccesses;
    }

    @Override
    public Integer getClientOfflineSessionIdleTimeout() {
        return this.fClientOfflineSessionIdleTimeout;
    }

    @Override
    public void setClientOfflineSessionIdleTimeout(Integer p0) {
        this.updated |= !Objects.equals(this.fClientOfflineSessionIdleTimeout, p0);
        this.fClientOfflineSessionIdleTimeout = p0;
    }

    @Override
    public Integer getClientOfflineSessionMaxLifespan() {
        return this.fClientOfflineSessionMaxLifespan;
    }

    @Override
    public void setClientOfflineSessionMaxLifespan(Integer p0) {
        this.updated |= !Objects.equals(this.fClientOfflineSessionMaxLifespan, p0);
        this.fClientOfflineSessionMaxLifespan = p0;
    }

    @Override
    public void setClientSessionIdleTimeout(Integer p0) {
        this.updated |= !Objects.equals(this.fClientSessionIdleTimeout, p0);
        this.fClientSessionIdleTimeout = p0;
    }

    @Override
    public Integer getClientSessionIdleTimeout() {
        return this.fClientSessionIdleTimeout;
    }

    @Override
    public void setClientSessionMaxLifespan(Integer p0) {
        this.updated |= !Objects.equals(this.fClientSessionMaxLifespan, p0);
        this.fClientSessionMaxLifespan = p0;
    }

    @Override
    public Integer getClientSessionMaxLifespan() {
        return this.fClientSessionMaxLifespan;
    }

    @Override
    public Set<MapComponentEntity> getComponents() {
        return this.fComponents;
    }

    @Override
    public void addComponent(MapComponentEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fComponents == null) {
            this.fComponents = new HashSet<MapComponentEntity>();
        }
        this.updated |= this.fComponents.add(p0);
    }

    @Override
    public Boolean removeDefaultClientScopeId(String p0) {
        if (this.fDefaultClientScopeIds == null) {
            return false;
        }
        boolean removed = this.fDefaultClientScopeIds.remove(p0);
        this.updated |= removed;
        return removed;
    }

    @Override
    public Set<String> getDefaultClientScopeIds() {
        return this.fDefaultClientScopeIds;
    }

    @Override
    public void addDefaultClientScopeId(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fDefaultClientScopeIds == null) {
            this.fDefaultClientScopeIds = new HashSet<String>();
        }
        this.updated |= this.fDefaultClientScopeIds.add(p0);
    }

    @Override
    public Set<String> getDefaultGroupIds() {
        return this.fDefaultGroupIds;
    }

    @Override
    public void removeDefaultGroupId(String p0) {
        if (this.fDefaultGroupIds == null) {
            return;
        }
        boolean removed = this.fDefaultGroupIds.remove(p0);
        this.updated |= removed;
    }

    @Override
    public void addDefaultGroupId(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fDefaultGroupIds == null) {
            this.fDefaultGroupIds = new HashSet<String>();
        }
        this.updated |= this.fDefaultGroupIds.add(p0);
    }

    @Override
    public void setDefaultLocale(String p0) {
        this.updated |= !Objects.equals(this.fDefaultLocale, p0);
        this.fDefaultLocale = p0;
    }

    @Override
    public String getDefaultLocale() {
        return this.fDefaultLocale;
    }

    @Override
    public void setDefaultRoleId(String p0) {
        this.updated |= !Objects.equals(this.fDefaultRoleId, p0);
        this.fDefaultRoleId = p0;
    }

    @Override
    public String getDefaultRoleId() {
        return this.fDefaultRoleId;
    }

    @Override
    public String getDirectGrantFlow() {
        return this.fDirectGrantFlow;
    }

    @Override
    public void setDirectGrantFlow(String p0) {
        this.updated |= !Objects.equals(this.fDirectGrantFlow, p0);
        this.fDirectGrantFlow = p0;
    }

    @Override
    public String getDisplayName() {
        return this.fDisplayName;
    }

    @Override
    public void setDisplayName(String p0) {
        this.updated |= !Objects.equals(this.fDisplayName, p0);
        this.fDisplayName = p0;
    }

    @Override
    public void setDisplayNameHtml(String p0) {
        this.updated |= !Objects.equals(this.fDisplayNameHtml, p0);
        this.fDisplayNameHtml = p0;
    }

    @Override
    public String getDisplayNameHtml() {
        return this.fDisplayNameHtml;
    }

    @Override
    public void setDockerAuthenticationFlow(String p0) {
        this.updated |= !Objects.equals(this.fDockerAuthenticationFlow, p0);
        this.fDockerAuthenticationFlow = p0;
    }

    @Override
    public String getDockerAuthenticationFlow() {
        return this.fDockerAuthenticationFlow;
    }

    @Override
    public void setDuplicateEmailsAllowed(Boolean p0) {
        this.updated |= !Objects.equals(this.fDuplicateEmailsAllowed, p0);
        this.fDuplicateEmailsAllowed = p0;
    }

    @Override
    public Boolean isDuplicateEmailsAllowed() {
        return this.fDuplicateEmailsAllowed;
    }

    @Override
    public Boolean isEditUsernameAllowed() {
        return this.fEditUsernameAllowed;
    }

    @Override
    public void setEditUsernameAllowed(Boolean p0) {
        this.updated |= !Objects.equals(this.fEditUsernameAllowed, p0);
        this.fEditUsernameAllowed = p0;
    }

    @Override
    public String getEmailTheme() {
        return this.fEmailTheme;
    }

    @Override
    public void setEmailTheme(String p0) {
        this.updated |= !Objects.equals(this.fEmailTheme, p0);
        this.fEmailTheme = p0;
    }

    @Override
    public Boolean isEnabled() {
        return this.fEnabled;
    }

    @Override
    public void setEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fEnabled, p0);
        this.fEnabled = p0;
    }

    @Override
    public void setEnabledEventTypes(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fEnabledEventTypes, p0);
        this.fEnabledEventTypes = p0;
    }

    @Override
    public Set<String> getEnabledEventTypes() {
        return this.fEnabledEventTypes;
    }

    @Override
    public Boolean isEventsEnabled() {
        return this.fEventsEnabled;
    }

    @Override
    public void setEventsEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fEventsEnabled, p0);
        this.fEventsEnabled = p0;
    }

    @Override
    public void setEventsExpiration(Long p0) {
        this.updated |= !Objects.equals(this.fEventsExpiration, p0);
        this.fEventsExpiration = p0;
    }

    @Override
    public Long getEventsExpiration() {
        return this.fEventsExpiration;
    }

    @Override
    public void setEventsListeners(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fEventsListeners, p0);
        this.fEventsListeners = p0;
    }

    @Override
    public Set<String> getEventsListeners() {
        return this.fEventsListeners;
    }

    @Override
    public Set<MapIdentityProviderMapperEntity> getIdentityProviderMappers() {
        return this.fIdentityProviderMappers;
    }

    @Override
    public void addIdentityProviderMapper(MapIdentityProviderMapperEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fIdentityProviderMappers == null) {
            this.fIdentityProviderMappers = new HashSet<MapIdentityProviderMapperEntity>();
        }
        this.updated |= this.fIdentityProviderMappers.add(p0);
    }

    @Override
    public Set<MapIdentityProviderEntity> getIdentityProviders() {
        return this.fIdentityProviders;
    }

    @Override
    public void addIdentityProvider(MapIdentityProviderEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fIdentityProviders == null) {
            this.fIdentityProviders = new HashSet<MapIdentityProviderEntity>();
        }
        this.updated |= this.fIdentityProviders.add(p0);
    }

    @Override
    public Boolean isInternationalizationEnabled() {
        return this.fInternationalizationEnabled;
    }

    @Override
    public void setInternationalizationEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fInternationalizationEnabled, p0);
        this.fInternationalizationEnabled = p0;
    }

    @Override
    public Map<String, String> getLocalizationText(String p0) {
        return this.fLocalizationTexts == null ? null : this.fLocalizationTexts.get(p0);
    }

    @Override
    public Map<String, Map<String, String>> getLocalizationTexts() {
        return this.fLocalizationTexts;
    }

    @Override
    public Boolean removeLocalizationText(String p0) {
        if (this.fLocalizationTexts == null) {
            return false;
        }
        boolean removed = this.fLocalizationTexts.remove(p0) != null;
        this.updated |= removed;
        return removed;
    }

    @Override
    public void setLocalizationText(String p0, Map<String, String> p1) {
        HashMap v;
        boolean valueUndefined;
        HashMap hashMap = p1 = p1 == null ? null : new HashMap(p1);
        if (p1 != null) {
            p1.values().removeIf(UndefinedValuesUtils::isUndefined);
        }
        if (valueUndefined = UndefinedValuesUtils.isUndefined(p1)) {
            if (this.fLocalizationTexts != null) {
                this.updated |= this.fLocalizationTexts.remove(p0) != null;
            }
            return;
        }
        if (this.fLocalizationTexts == null) {
            this.fLocalizationTexts = new HashMap<String, Map<String, String>>();
        }
        this.updated |= !Objects.equals(v = this.fLocalizationTexts.put(p0, p1), p1);
    }

    @Override
    public String getLoginTheme() {
        return this.fLoginTheme;
    }

    @Override
    public void setLoginTheme(String p0) {
        this.updated |= !Objects.equals(this.fLoginTheme, p0);
        this.fLoginTheme = p0;
    }

    @Override
    public Boolean isLoginWithEmailAllowed() {
        return this.fLoginWithEmailAllowed;
    }

    @Override
    public void setLoginWithEmailAllowed(Boolean p0) {
        this.updated |= !Objects.equals(this.fLoginWithEmailAllowed, p0);
        this.fLoginWithEmailAllowed = p0;
    }

    @Override
    public String getMasterAdminClient() {
        return this.fMasterAdminClient;
    }

    @Override
    public void setMasterAdminClient(String p0) {
        this.updated |= !Objects.equals(this.fMasterAdminClient, p0);
        this.fMasterAdminClient = p0;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String p0) {
        this.updated |= !Objects.equals(this.fName, p0);
        this.fName = p0;
    }

    @Override
    public Long getNotBefore() {
        return this.fNotBefore;
    }

    @Override
    public void setNotBefore(Long p0) {
        this.updated |= !Objects.equals(this.fNotBefore, p0);
        this.fNotBefore = p0;
    }

    @Override
    public MapOTPPolicyEntity getOTPPolicy() {
        return this.fOTPPolicy;
    }

    @Override
    public void setOTPPolicy(MapOTPPolicyEntity p0) {
        this.updated |= !Objects.equals(this.fOTPPolicy, p0 = this.deepClone(p0));
        this.fOTPPolicy = p0;
    }

    @Override
    public void setOfflineSessionIdleTimeout(Integer p0) {
        this.updated |= !Objects.equals(this.fOfflineSessionIdleTimeout, p0);
        this.fOfflineSessionIdleTimeout = p0;
    }

    @Override
    public Integer getOfflineSessionIdleTimeout() {
        return this.fOfflineSessionIdleTimeout;
    }

    @Override
    public Integer getOfflineSessionMaxLifespan() {
        return this.fOfflineSessionMaxLifespan;
    }

    @Override
    public void setOfflineSessionMaxLifespan(Integer p0) {
        this.updated |= !Objects.equals(this.fOfflineSessionMaxLifespan, p0);
        this.fOfflineSessionMaxLifespan = p0;
    }

    @Override
    public Boolean isOfflineSessionMaxLifespanEnabled() {
        return this.fOfflineSessionMaxLifespanEnabled;
    }

    @Override
    public void setOfflineSessionMaxLifespanEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fOfflineSessionMaxLifespanEnabled, p0);
        this.fOfflineSessionMaxLifespanEnabled = p0;
    }

    @Override
    public Set<String> getOptionalClientScopeIds() {
        return this.fOptionalClientScopeIds;
    }

    @Override
    public void addOptionalClientScopeId(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fOptionalClientScopeIds == null) {
            this.fOptionalClientScopeIds = new HashSet<String>();
        }
        this.updated |= this.fOptionalClientScopeIds.add(p0);
    }

    @Override
    public Boolean removeOptionalClientScopeId(String p0) {
        if (this.fOptionalClientScopeIds == null) {
            return false;
        }
        boolean removed = this.fOptionalClientScopeIds.remove(p0);
        this.updated |= removed;
        return removed;
    }

    @Override
    public void setPasswordPolicy(String p0) {
        this.updated |= !Objects.equals(this.fPasswordPolicy, p0);
        this.fPasswordPolicy = p0;
    }

    @Override
    public String getPasswordPolicy() {
        return this.fPasswordPolicy;
    }

    @Override
    public Integer getRefreshTokenMaxReuse() {
        return this.fRefreshTokenMaxReuse;
    }

    @Override
    public void setRefreshTokenMaxReuse(Integer p0) {
        this.updated |= !Objects.equals(this.fRefreshTokenMaxReuse, p0);
        this.fRefreshTokenMaxReuse = p0;
    }

    @Override
    public void setRegistrationAllowed(Boolean p0) {
        this.updated |= !Objects.equals(this.fRegistrationAllowed, p0);
        this.fRegistrationAllowed = p0;
    }

    @Override
    public Boolean isRegistrationAllowed() {
        return this.fRegistrationAllowed;
    }

    @Override
    public Boolean isRegistrationEmailAsUsername() {
        return this.fRegistrationEmailAsUsername;
    }

    @Override
    public void setRegistrationEmailAsUsername(Boolean p0) {
        this.updated |= !Objects.equals(this.fRegistrationEmailAsUsername, p0);
        this.fRegistrationEmailAsUsername = p0;
    }

    @Override
    public String getRegistrationFlow() {
        return this.fRegistrationFlow;
    }

    @Override
    public void setRegistrationFlow(String p0) {
        this.updated |= !Objects.equals(this.fRegistrationFlow, p0);
        this.fRegistrationFlow = p0;
    }

    @Override
    public Boolean isRememberMe() {
        return this.fRememberMe;
    }

    @Override
    public void setRememberMe(Boolean p0) {
        this.updated |= !Objects.equals(this.fRememberMe, p0);
        this.fRememberMe = p0;
    }

    @Override
    public void addRequiredActionProvider(MapRequiredActionProviderEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fRequiredActionProviders == null) {
            this.fRequiredActionProviders = new HashSet<MapRequiredActionProviderEntity>();
        }
        this.updated |= this.fRequiredActionProviders.add(p0);
    }

    @Override
    public Set<MapRequiredActionProviderEntity> getRequiredActionProviders() {
        return this.fRequiredActionProviders;
    }

    @Override
    public Set<MapRequiredCredentialEntity> getRequiredCredentials() {
        return this.fRequiredCredentials;
    }

    @Override
    public void addRequiredCredential(MapRequiredCredentialEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fRequiredCredentials == null) {
            this.fRequiredCredentials = new HashSet<MapRequiredCredentialEntity>();
        }
        this.updated |= this.fRequiredCredentials.add(p0);
    }

    @Override
    public String getResetCredentialsFlow() {
        return this.fResetCredentialsFlow;
    }

    @Override
    public void setResetCredentialsFlow(String p0) {
        this.updated |= !Objects.equals(this.fResetCredentialsFlow, p0);
        this.fResetCredentialsFlow = p0;
    }

    @Override
    public Boolean isResetPasswordAllowed() {
        return this.fResetPasswordAllowed;
    }

    @Override
    public void setResetPasswordAllowed(Boolean p0) {
        this.updated |= !Objects.equals(this.fResetPasswordAllowed, p0);
        this.fResetPasswordAllowed = p0;
    }

    @Override
    public void setRevokeRefreshToken(Boolean p0) {
        this.updated |= !Objects.equals(this.fRevokeRefreshToken, p0);
        this.fRevokeRefreshToken = p0;
    }

    @Override
    public Boolean isRevokeRefreshToken() {
        return this.fRevokeRefreshToken;
    }

    @Override
    public Map<String, String> getSmtpConfig() {
        return this.fSmtpConfig;
    }

    @Override
    public void setSmtpConfig(Map<String, String> p0) {
        HashMap<String, String> hashMap = p0 = p0 == null ? null : new HashMap<String, String>(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fSmtpConfig, p0);
        this.fSmtpConfig = p0;
    }

    @Override
    public void setSslRequired(String p0) {
        this.updated |= !Objects.equals(this.fSslRequired, p0);
        this.fSslRequired = p0;
    }

    @Override
    public String getSslRequired() {
        return this.fSslRequired;
    }

    @Override
    public void setSsoSessionIdleTimeout(Integer p0) {
        this.updated |= !Objects.equals(this.fSsoSessionIdleTimeout, p0);
        this.fSsoSessionIdleTimeout = p0;
    }

    @Override
    public Integer getSsoSessionIdleTimeout() {
        return this.fSsoSessionIdleTimeout;
    }

    @Override
    public Integer getSsoSessionIdleTimeoutRememberMe() {
        return this.fSsoSessionIdleTimeoutRememberMe;
    }

    @Override
    public void setSsoSessionIdleTimeoutRememberMe(Integer p0) {
        this.updated |= !Objects.equals(this.fSsoSessionIdleTimeoutRememberMe, p0);
        this.fSsoSessionIdleTimeoutRememberMe = p0;
    }

    @Override
    public void setSsoSessionMaxLifespan(Integer p0) {
        this.updated |= !Objects.equals(this.fSsoSessionMaxLifespan, p0);
        this.fSsoSessionMaxLifespan = p0;
    }

    @Override
    public Integer getSsoSessionMaxLifespan() {
        return this.fSsoSessionMaxLifespan;
    }

    @Override
    public Integer getSsoSessionMaxLifespanRememberMe() {
        return this.fSsoSessionMaxLifespanRememberMe;
    }

    @Override
    public void setSsoSessionMaxLifespanRememberMe(Integer p0) {
        this.updated |= !Objects.equals(this.fSsoSessionMaxLifespanRememberMe, p0);
        this.fSsoSessionMaxLifespanRememberMe = p0;
    }

    @Override
    public Set<String> getSupportedLocales() {
        return this.fSupportedLocales;
    }

    @Override
    public void setSupportedLocales(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fSupportedLocales, p0);
        this.fSupportedLocales = p0;
    }

    @Override
    public void setVerifyEmail(Boolean p0) {
        this.updated |= !Objects.equals(this.fVerifyEmail, p0);
        this.fVerifyEmail = p0;
    }

    @Override
    public Boolean isVerifyEmail() {
        return this.fVerifyEmail;
    }

    @Override
    public MapWebAuthnPolicyEntity getWebAuthnPolicy() {
        return this.fWebAuthnPolicy;
    }

    @Override
    public void setWebAuthnPolicy(MapWebAuthnPolicyEntity p0) {
        this.updated |= !Objects.equals(this.fWebAuthnPolicy, p0 = this.deepClone(p0));
        this.fWebAuthnPolicy = p0;
    }

    @Override
    public void setWebAuthnPolicyPasswordless(MapWebAuthnPolicyEntity p0) {
        this.updated |= !Objects.equals(this.fWebAuthnPolicyPasswordless, p0 = this.deepClone(p0));
        this.fWebAuthnPolicyPasswordless = p0;
    }

    @Override
    public MapWebAuthnPolicyEntity getWebAuthnPolicyPasswordless() {
        return this.fWebAuthnPolicyPasswordless;
    }

    public static class Empty
    extends MapRealmEntity.AbstractRealmEntity
    implements MapRealmEntity {
        public static final Empty INSTANCE = new Empty();

        @Override
        public void setId(String id) {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public void setAccessCodeLifespan(Integer accessCodeLifespan) {
        }

        @Override
        public Integer getAccessCodeLifespan() {
            return null;
        }

        @Override
        public Integer getAccessCodeLifespanLogin() {
            return null;
        }

        @Override
        public void setAccessCodeLifespanLogin(Integer accessCodeLifespanLogin) {
        }

        @Override
        public Integer getAccessCodeLifespanUserAction() {
            return null;
        }

        @Override
        public void setAccessCodeLifespanUserAction(Integer accessCodeLifespanUserAction) {
        }

        @Override
        public void setAccessTokenLifespan(Integer accessTokenLifespan) {
        }

        @Override
        public Integer getAccessTokenLifespan() {
            return null;
        }

        @Override
        public Integer getAccessTokenLifespanForImplicitFlow() {
            return null;
        }

        @Override
        public void setAccessTokenLifespanForImplicitFlow(Integer accessTokenLifespanForImplicitFlow) {
        }

        @Override
        public void setAccountTheme(String accountTheme) {
        }

        @Override
        public String getAccountTheme() {
            return null;
        }

        @Override
        public void setActionTokenGeneratedByAdminLifespan(Integer actionTokenGeneratedByAdminLifespan) {
        }

        @Override
        public Integer getActionTokenGeneratedByAdminLifespan() {
            return null;
        }

        @Override
        public void setAdminEventsDetailsEnabled(Boolean adminEventsDetailsEnabled) {
        }

        @Override
        public Boolean isAdminEventsDetailsEnabled() {
            return null;
        }

        @Override
        public void setAdminEventsEnabled(Boolean adminEventsEnabled) {
        }

        @Override
        public Boolean isAdminEventsEnabled() {
            return null;
        }

        @Override
        public void setAdminTheme(String adminTheme) {
        }

        @Override
        public String getAdminTheme() {
            return null;
        }

        @Override
        public Boolean isAllowUserManagedAccess() {
            return null;
        }

        @Override
        public void setAllowUserManagedAccess(Boolean allowUserManagedAccess) {
        }

        @Override
        public void setAttribute(String name, List<String> value) {
        }

        @Override
        public Map<String, List<String>> getAttributes() {
            return null;
        }

        @Override
        public void setAttributes(Map<String, List<String>> attributes) {
        }

        @Override
        public List<String> getAttribute(String name) {
            return null;
        }

        @Override
        public void removeAttribute(String name) {
        }

        @Override
        public void addAuthenticationExecution(MapAuthenticationExecutionEntity authenticationExecution) {
        }

        @Override
        public Set<MapAuthenticationExecutionEntity> getAuthenticationExecutions() {
            return null;
        }

        @Override
        public Optional<MapAuthenticationExecutionEntity> getAuthenticationExecution(String id) {
            return null;
        }

        @Override
        public Boolean removeAuthenticationExecution(String executionId) {
            return null;
        }

        @Override
        public Optional<MapAuthenticationFlowEntity> getAuthenticationFlow(String flowId) {
            return null;
        }

        @Override
        public void addAuthenticationFlow(MapAuthenticationFlowEntity authenticationFlow) {
        }

        @Override
        public Set<MapAuthenticationFlowEntity> getAuthenticationFlows() {
            return null;
        }

        @Override
        public Boolean removeAuthenticationFlow(String flowId) {
            return null;
        }

        @Override
        public void addAuthenticatorConfig(MapAuthenticatorConfigEntity authenticatorConfig) {
        }

        @Override
        public Boolean removeAuthenticatorConfig(String authenticatorConfigId) {
            return null;
        }

        @Override
        public Optional<MapAuthenticatorConfigEntity> getAuthenticatorConfig(String authenticatorConfigId) {
            return null;
        }

        @Override
        public Set<MapAuthenticatorConfigEntity> getAuthenticatorConfigs() {
            return null;
        }

        @Override
        public void setBrowserFlow(String browserFlow) {
        }

        @Override
        public String getBrowserFlow() {
            return null;
        }

        @Override
        public void setBrowserSecurityHeader(String name, String value) {
        }

        @Override
        public void setBrowserSecurityHeaders(Map<String, String> headers) {
        }

        @Override
        public Map<String, String> getBrowserSecurityHeaders() {
            return null;
        }

        @Override
        public void setClientAuthenticationFlow(String clientAuthenticationFlow) {
        }

        @Override
        public String getClientAuthenticationFlow() {
            return null;
        }

        @Override
        public void addClientInitialAccess(MapClientInitialAccessEntity clientInitialAccess) {
        }

        @Override
        public Optional<MapClientInitialAccessEntity> getClientInitialAccess(String clientInitialAccessId) {
            return null;
        }

        @Override
        public Set<MapClientInitialAccessEntity> getClientInitialAccesses() {
            return null;
        }

        @Override
        public Boolean removeClientInitialAccess(String clientInitialAccessId) {
            return null;
        }

        @Override
        public Integer getClientOfflineSessionIdleTimeout() {
            return null;
        }

        @Override
        public void setClientOfflineSessionIdleTimeout(Integer clientOfflineSessionIdleTimeout) {
        }

        @Override
        public Integer getClientOfflineSessionMaxLifespan() {
            return null;
        }

        @Override
        public void setClientOfflineSessionMaxLifespan(Integer clientOfflineSessionMaxLifespan) {
        }

        @Override
        public void setClientSessionIdleTimeout(Integer clientSessionIdleTimeout) {
        }

        @Override
        public Integer getClientSessionIdleTimeout() {
            return null;
        }

        @Override
        public void setClientSessionMaxLifespan(Integer clientSessionMaxLifespan) {
        }

        @Override
        public Integer getClientSessionMaxLifespan() {
            return null;
        }

        @Override
        public Optional<MapComponentEntity> getComponent(String id) {
            return null;
        }

        @Override
        public Boolean removeComponent(String componentId) {
            return null;
        }

        @Override
        public Set<MapComponentEntity> getComponents() {
            return null;
        }

        @Override
        public void addComponent(MapComponentEntity component) {
        }

        @Override
        public Boolean removeDefaultClientScopeId(String scopeId) {
            return null;
        }

        @Override
        public Set<String> getDefaultClientScopeIds() {
            return null;
        }

        @Override
        public void addDefaultClientScopeId(String scopeId) {
        }

        @Override
        public Set<String> getDefaultGroupIds() {
            return null;
        }

        @Override
        public void removeDefaultGroupId(String groupId) {
        }

        @Override
        public void addDefaultGroupId(String groupId) {
        }

        @Override
        public void setDefaultLocale(String defaultLocale) {
        }

        @Override
        public String getDefaultLocale() {
            return null;
        }

        @Override
        public void setDefaultRoleId(String defaultRoleId) {
        }

        @Override
        public String getDefaultRoleId() {
            return null;
        }

        @Override
        public String getDirectGrantFlow() {
            return null;
        }

        @Override
        public void setDirectGrantFlow(String directGrantFlow) {
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public void setDisplayName(String displayName) {
        }

        @Override
        public void setDisplayNameHtml(String displayNameHtml) {
        }

        @Override
        public String getDisplayNameHtml() {
            return null;
        }

        @Override
        public void setDockerAuthenticationFlow(String dockerAuthenticationFlow) {
        }

        @Override
        public String getDockerAuthenticationFlow() {
            return null;
        }

        @Override
        public void setDuplicateEmailsAllowed(Boolean duplicateEmailsAllowed) {
        }

        @Override
        public Boolean isDuplicateEmailsAllowed() {
            return null;
        }

        @Override
        public Boolean isEditUsernameAllowed() {
            return null;
        }

        @Override
        public void setEditUsernameAllowed(Boolean editUsernameAllowed) {
        }

        @Override
        public String getEmailTheme() {
            return null;
        }

        @Override
        public void setEmailTheme(String emailTheme) {
        }

        @Override
        public Boolean isEnabled() {
            return null;
        }

        @Override
        public void setEnabled(Boolean enabled) {
        }

        @Override
        public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        }

        @Override
        public Set<String> getEnabledEventTypes() {
            return null;
        }

        @Override
        public Boolean isEventsEnabled() {
            return null;
        }

        @Override
        public void setEventsEnabled(Boolean eventsEnabled) {
        }

        @Override
        public void setEventsExpiration(Long eventsExpiration) {
        }

        @Override
        public Long getEventsExpiration() {
            return null;
        }

        @Override
        public void setEventsListeners(Set<String> eventsListeners) {
        }

        @Override
        public Set<String> getEventsListeners() {
            return null;
        }

        @Override
        public Set<MapIdentityProviderMapperEntity> getIdentityProviderMappers() {
            return null;
        }

        @Override
        public void addIdentityProviderMapper(MapIdentityProviderMapperEntity identityProviderMapper) {
        }

        @Override
        public Boolean removeIdentityProviderMapper(String identityProviderMapperId) {
            return null;
        }

        @Override
        public Optional<MapIdentityProviderMapperEntity> getIdentityProviderMapper(String identityProviderMapperId) {
            return null;
        }

        @Override
        public Set<MapIdentityProviderEntity> getIdentityProviders() {
            return null;
        }

        @Override
        public Boolean removeIdentityProvider(String identityProviderId) {
            return null;
        }

        @Override
        public void addIdentityProvider(MapIdentityProviderEntity identityProvider) {
        }

        @Override
        public Boolean isInternationalizationEnabled() {
            return null;
        }

        @Override
        public void setInternationalizationEnabled(Boolean internationalizationEnabled) {
        }

        @Override
        public Map<String, String> getLocalizationText(String locale) {
            return null;
        }

        @Override
        public Map<String, Map<String, String>> getLocalizationTexts() {
            return null;
        }

        @Override
        public Boolean removeLocalizationText(String locale) {
            return null;
        }

        @Override
        public void setLocalizationText(String locale, Map<String, String> texts) {
        }

        @Override
        public String getLoginTheme() {
            return null;
        }

        @Override
        public void setLoginTheme(String loginTheme) {
        }

        @Override
        public Boolean isLoginWithEmailAllowed() {
            return null;
        }

        @Override
        public void setLoginWithEmailAllowed(Boolean loginWithEmailAllowed) {
        }

        @Override
        public String getMasterAdminClient() {
            return null;
        }

        @Override
        public void setMasterAdminClient(String masterAdminClient) {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public Long getNotBefore() {
            return null;
        }

        @Override
        public void setNotBefore(Long notBefore) {
        }

        @Override
        public MapOTPPolicyEntity getOTPPolicy() {
            return null;
        }

        @Override
        public void setOTPPolicy(MapOTPPolicyEntity otpPolicy) {
        }

        @Override
        public void setOfflineSessionIdleTimeout(Integer offlineSessionIdleTimeout) {
        }

        @Override
        public Integer getOfflineSessionIdleTimeout() {
            return null;
        }

        @Override
        public Integer getOfflineSessionMaxLifespan() {
            return null;
        }

        @Override
        public void setOfflineSessionMaxLifespan(Integer offlineSessionMaxLifespan) {
        }

        @Override
        public Boolean isOfflineSessionMaxLifespanEnabled() {
            return null;
        }

        @Override
        public void setOfflineSessionMaxLifespanEnabled(Boolean offlineSessionMaxLifespanEnabled) {
        }

        @Override
        public Set<String> getOptionalClientScopeIds() {
            return null;
        }

        @Override
        public void addOptionalClientScopeId(String scopeId) {
        }

        @Override
        public Boolean removeOptionalClientScopeId(String scopeId) {
            return null;
        }

        @Override
        public void setPasswordPolicy(String passwordPolicy) {
        }

        @Override
        public String getPasswordPolicy() {
            return null;
        }

        @Override
        public Integer getRefreshTokenMaxReuse() {
            return null;
        }

        @Override
        public void setRefreshTokenMaxReuse(Integer refreshTokenMaxReuse) {
        }

        @Override
        public void setRegistrationAllowed(Boolean registrationAllowed) {
        }

        @Override
        public Boolean isRegistrationAllowed() {
            return null;
        }

        @Override
        public Boolean isRegistrationEmailAsUsername() {
            return null;
        }

        @Override
        public void setRegistrationEmailAsUsername(Boolean registrationEmailAsUsername) {
        }

        @Override
        public String getRegistrationFlow() {
            return null;
        }

        @Override
        public void setRegistrationFlow(String registrationFlow) {
        }

        @Override
        public Boolean isRememberMe() {
            return null;
        }

        @Override
        public void setRememberMe(Boolean rememberMe) {
        }

        @Override
        public void addRequiredActionProvider(MapRequiredActionProviderEntity requiredActionProvider) {
        }

        @Override
        public Set<MapRequiredActionProviderEntity> getRequiredActionProviders() {
            return null;
        }

        @Override
        public Optional<MapRequiredActionProviderEntity> getRequiredActionProvider(String requiredActionProviderId) {
            return null;
        }

        @Override
        public Boolean removeRequiredActionProvider(String requiredActionProviderId) {
            return null;
        }

        @Override
        public Set<MapRequiredCredentialEntity> getRequiredCredentials() {
            return null;
        }

        @Override
        public void addRequiredCredential(MapRequiredCredentialEntity requiredCredential) {
        }

        @Override
        public String getResetCredentialsFlow() {
            return null;
        }

        @Override
        public void setResetCredentialsFlow(String resetCredentialsFlow) {
        }

        @Override
        public Boolean isResetPasswordAllowed() {
            return null;
        }

        @Override
        public void setResetPasswordAllowed(Boolean resetPasswordAllowed) {
        }

        @Override
        public void setRevokeRefreshToken(Boolean revokeRefreshToken) {
        }

        @Override
        public Boolean isRevokeRefreshToken() {
            return null;
        }

        @Override
        public Map<String, String> getSmtpConfig() {
            return null;
        }

        @Override
        public void setSmtpConfig(Map<String, String> smtpConfig) {
        }

        @Override
        public void setSslRequired(String sslRequired) {
        }

        @Override
        public String getSslRequired() {
            return null;
        }

        @Override
        public void setSsoSessionIdleTimeout(Integer ssoSessionIdleTimeout) {
        }

        @Override
        public Integer getSsoSessionIdleTimeout() {
            return null;
        }

        @Override
        public Integer getSsoSessionIdleTimeoutRememberMe() {
            return null;
        }

        @Override
        public void setSsoSessionIdleTimeoutRememberMe(Integer ssoSessionIdleTimeoutRememberMe) {
        }

        @Override
        public void setSsoSessionMaxLifespan(Integer ssoSessionMaxLifespan) {
        }

        @Override
        public Integer getSsoSessionMaxLifespan() {
            return null;
        }

        @Override
        public Integer getSsoSessionMaxLifespanRememberMe() {
            return null;
        }

        @Override
        public void setSsoSessionMaxLifespanRememberMe(Integer ssoSessionMaxLifespanRememberMe) {
        }

        @Override
        public Set<String> getSupportedLocales() {
            return null;
        }

        @Override
        public void setSupportedLocales(Set<String> supportedLocales) {
        }

        @Override
        public void setVerifyEmail(Boolean verifyEmail) {
        }

        @Override
        public Boolean isVerifyEmail() {
            return null;
        }

        @Override
        public MapWebAuthnPolicyEntity getWebAuthnPolicy() {
            return null;
        }

        @Override
        public void setWebAuthnPolicy(MapWebAuthnPolicyEntity webAuthnPolicy) {
        }

        @Override
        public void setWebAuthnPolicyPasswordless(MapWebAuthnPolicyEntity webAuthnPolicyPasswordless) {
        }

        @Override
        public MapWebAuthnPolicyEntity getWebAuthnPolicyPasswordless() {
            return null;
        }

        @Override
        public boolean isUpdated() {
            return false;
        }
    }
}

