/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.map.common.UpdatableEntity;

public class MapWebAuthnPolicyEntity
extends UpdatableEntity.Impl {
    private String rpEntityName;
    private List<String> signatureAlgorithms = new LinkedList<String>();
    private String rpId;
    private String attestationConveyancePreference;
    private String authenticatorAttachment;
    private String requireResidentKey;
    private String userVerificationRequirement;
    private Integer createTimeout = 0;
    private Boolean avoidSameAuthenticatorRegister = false;
    private List<String> acceptableAaguids = new LinkedList<String>();

    private MapWebAuthnPolicyEntity() {
    }

    public static MapWebAuthnPolicyEntity fromModel(WebAuthnPolicy model) {
        if (model == null) {
            return null;
        }
        MapWebAuthnPolicyEntity entity = new MapWebAuthnPolicyEntity();
        entity.setRpEntityName(model.getRpEntityName());
        entity.setSignatureAlgorithms(model.getSignatureAlgorithm());
        entity.setRpId(model.getRpId());
        entity.setAttestationConveyancePreference(model.getAttestationConveyancePreference());
        entity.setAuthenticatorAttachment(model.getAuthenticatorAttachment());
        entity.setRequireResidentKey(model.getRequireResidentKey());
        entity.setUserVerificationRequirement(model.getUserVerificationRequirement());
        entity.setCreateTimeout(model.getCreateTimeout());
        entity.setAvoidSameAuthenticatorRegister(model.isAvoidSameAuthenticatorRegister());
        entity.setAcceptableAaguids(model.getAcceptableAaguids() == null ? null : new LinkedList(model.getAcceptableAaguids()));
        return entity;
    }

    public static WebAuthnPolicy toModel(MapWebAuthnPolicyEntity entity) {
        if (entity == null) {
            return null;
        }
        WebAuthnPolicy model = new WebAuthnPolicy();
        model.setRpEntityName(entity.getRpEntityName());
        model.setSignatureAlgorithm(entity.getSignatureAlgorithms());
        model.setRpId(entity.getRpId());
        model.setAttestationConveyancePreference(entity.getAttestationConveyancePreference());
        model.setAuthenticatorAttachment(entity.getAuthenticatorAttachment());
        model.setRequireResidentKey(entity.getRequireResidentKey());
        model.setUserVerificationRequirement(entity.getUserVerificationRequirement());
        model.setCreateTimeout(entity.getCreateTimeout().intValue());
        model.setAvoidSameAuthenticatorRegister(entity.isAvoidSameAuthenticatorRegister().booleanValue());
        model.setAcceptableAaguids((List)(entity.getAcceptableAaguids() == null ? null : new LinkedList<String>(entity.getAcceptableAaguids())));
        return model;
    }

    public static MapWebAuthnPolicyEntity defaultWebAuthnPolicy() {
        MapWebAuthnPolicyEntity entity = new MapWebAuthnPolicyEntity();
        entity.setRpEntityName("keycloak");
        entity.setSignatureAlgorithms(Arrays.asList("ES256".split(",")));
        entity.setRpId("");
        entity.setAttestationConveyancePreference("not specified");
        entity.setAuthenticatorAttachment("not specified");
        entity.setRequireResidentKey("not specified");
        entity.setUserVerificationRequirement("not specified");
        entity.setCreateTimeout(0);
        entity.setAvoidSameAuthenticatorRegister(false);
        entity.setAcceptableAaguids(new LinkedList<String>());
        return entity;
    }

    public String getRpEntityName() {
        return this.rpEntityName;
    }

    public void setRpEntityName(String rpEntityName) {
        this.updated = !Objects.equals(this.rpEntityName, rpEntityName);
        this.rpEntityName = rpEntityName;
    }

    public List<String> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.updated = !Objects.equals(this.signatureAlgorithms, signatureAlgorithms);
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public String getRpId() {
        return this.rpId;
    }

    public void setRpId(String rpId) {
        this.updated = !Objects.equals(this.rpId, rpId);
        this.rpId = rpId;
    }

    public String getAttestationConveyancePreference() {
        return this.attestationConveyancePreference;
    }

    public void setAttestationConveyancePreference(String attestationConveyancePreference) {
        this.updated = !Objects.equals(this.attestationConveyancePreference, attestationConveyancePreference);
        this.attestationConveyancePreference = attestationConveyancePreference;
    }

    public String getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public void setAuthenticatorAttachment(String authenticatorAttachment) {
        this.updated = !Objects.equals(this.authenticatorAttachment, authenticatorAttachment);
        this.authenticatorAttachment = authenticatorAttachment;
    }

    public String getRequireResidentKey() {
        return this.requireResidentKey;
    }

    public void setRequireResidentKey(String requireResidentKey) {
        this.updated = !Objects.equals(this.requireResidentKey, requireResidentKey);
        this.requireResidentKey = requireResidentKey;
    }

    public String getUserVerificationRequirement() {
        return this.userVerificationRequirement;
    }

    public void setUserVerificationRequirement(String userVerificationRequirement) {
        this.updated = !Objects.equals(this.userVerificationRequirement, userVerificationRequirement);
        this.userVerificationRequirement = userVerificationRequirement;
    }

    public Integer getCreateTimeout() {
        return this.createTimeout;
    }

    public void setCreateTimeout(int createTimeout) {
        this.updated = !Objects.equals(this.createTimeout, createTimeout);
        this.createTimeout = createTimeout;
    }

    public Boolean isAvoidSameAuthenticatorRegister() {
        return this.avoidSameAuthenticatorRegister;
    }

    public void setAvoidSameAuthenticatorRegister(boolean avoidSameAuthenticatorRegister) {
        this.updated = !Objects.equals(this.avoidSameAuthenticatorRegister, avoidSameAuthenticatorRegister);
        this.avoidSameAuthenticatorRegister = avoidSameAuthenticatorRegister;
    }

    public List<String> getAcceptableAaguids() {
        return this.acceptableAaguids;
    }

    public void setAcceptableAaguids(List<String> acceptableAaguids) {
        this.updated = !Objects.equals(this.acceptableAaguids, acceptableAaguids);
        this.acceptableAaguids = acceptableAaguids;
    }

    public int hashCode() {
        return this.getRpEntityName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapWebAuthnPolicyEntity)) {
            return false;
        }
        MapWebAuthnPolicyEntity other = (MapWebAuthnPolicyEntity)obj;
        return Objects.equals(other.getRpEntityName(), this.getRpEntityName());
    }
}

