/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;

class CriteriaOperator {
    private static final EnumMap<ModelCriteriaBuilder.Operator, Function<Object[], Predicate<Object>>> OPERATORS = new EnumMap(ModelCriteriaBuilder.Operator.class);
    private static final Logger LOG = Logger.getLogger(CriteriaOperator.class.getSimpleName());
    private static final Predicate<Object> ALWAYS_FALSE = o -> false;

    CriteriaOperator() {
    }

    public static Predicate<Object> predicateFor(ModelCriteriaBuilder.Operator op, Object[] value) {
        Function<Object[], Predicate<Object>> funcToGetPredicate = OPERATORS.get((Object)op);
        if (funcToGetPredicate == null) {
            throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
        }
        return funcToGetPredicate.apply(value);
    }

    private static Object getFirstArrayElement(Object[] value) throws IllegalStateException {
        if (value == null || value.length != 1) {
            throw new IllegalStateException("Invalid argument: " + Arrays.toString(value));
        }
        return value[0];
    }

    public static Predicate<Object> eq(Object[] value) {
        final Object value0 = CriteriaOperator.getFirstArrayElement(value);
        return new Predicate<Object>(){

            @Override
            public boolean test(Object v) {
                return Objects.equals(v, value0);
            }
        };
    }

    public static Predicate<Object> ne(Object[] value) {
        final Object value0 = CriteriaOperator.getFirstArrayElement(value);
        return new Predicate<Object>(){

            @Override
            public boolean test(Object v) {
                return !Objects.equals(v, value0);
            }
        };
    }

    public static Predicate<Object> exists(Object[] value) {
        if (value != null && value.length != 0) {
            throw new IllegalStateException("Invalid argument: " + Arrays.toString(value));
        }
        return CriteriaOperator::collectionAwareExists;
    }

    private static boolean collectionAwareExists(Object checkedObject) {
        if (checkedObject instanceof Collection) {
            return !((Collection)checkedObject).isEmpty();
        }
        return Objects.nonNull(checkedObject);
    }

    public static Predicate<Object> notExists(Object[] value) {
        if (value != null && value.length != 0) {
            throw new IllegalStateException("Invalid argument: " + Arrays.toString(value));
        }
        return CriteriaOperator::collectionAwareNotExists;
    }

    private static boolean collectionAwareNotExists(Object checkedObject) {
        if (Objects.isNull(checkedObject)) {
            return true;
        }
        if (checkedObject instanceof Collection) {
            return ((Collection)checkedObject).isEmpty();
        }
        return false;
    }

    public static Predicate<Object> in(Object[] value) {
        Collection<Object> operand;
        if (value == null || value.length == 0) {
            return ALWAYS_FALSE;
        }
        if (value.length == 1) {
            Object value0 = value[0];
            if (value0 instanceof Collection) {
                operand = (Collection)value0;
            } else if (value0 instanceof Stream) {
                try (Stream valueS = (Stream)value0;){
                    operand = valueS.collect(Collectors.toSet());
                }
            } else {
                operand = Collections.singleton(value0);
            }
        } else {
            operand = new HashSet<Object>(Arrays.asList(value));
        }
        return operand.isEmpty() ? ALWAYS_FALSE : new Predicate<Object>(){

            @Override
            public boolean test(Object v) {
                return operand.contains(v);
            }
        };
    }

    public static Predicate<Object> lt(Object[] value) {
        return CriteriaOperator.getComparisonPredicate(ComparisonPredicateImpl.Op.LT, value);
    }

    public static Predicate<Object> le(Object[] value) {
        return CriteriaOperator.getComparisonPredicate(ComparisonPredicateImpl.Op.LE, value);
    }

    public static Predicate<Object> gt(Object[] value) {
        return CriteriaOperator.getComparisonPredicate(ComparisonPredicateImpl.Op.GT, value);
    }

    public static Predicate<Object> ge(Object[] value) {
        return CriteriaOperator.getComparisonPredicate(ComparisonPredicateImpl.Op.GE, value);
    }

    private static Predicate<Object> getComparisonPredicate(ComparisonPredicateImpl.Op op, Object[] value) throws IllegalArgumentException {
        Object value0 = CriteriaOperator.getFirstArrayElement(value);
        if (value0 instanceof Comparable) {
            Comparable cValue = (Comparable)value0;
            return new ComparisonPredicateImpl(op, cValue);
        }
        throw new IllegalArgumentException("Incomparable argument for comparison operation: " + value0);
    }

    public static Predicate<Object> like(Object[] value) {
        Object value0 = CriteriaOperator.getFirstArrayElement(value);
        if (value0 instanceof String) {
            String sValue = (String)value0;
            boolean anyBeginning = sValue.startsWith("%");
            boolean anyEnd = sValue.endsWith("%");
            Pattern pValue = Pattern.compile((anyBeginning ? ".*" : "") + Pattern.quote(sValue.substring(anyBeginning ? 1 : 0, sValue.length() - (anyEnd ? 1 : 0))) + (anyEnd ? ".*" : ""), 32);
            return o -> o instanceof String && pValue.matcher((String)o).matches();
        }
        return ALWAYS_FALSE;
    }

    public static Predicate<Object> ilike(Object[] value) {
        Object value0 = CriteriaOperator.getFirstArrayElement(value);
        if (value0 instanceof String) {
            String sValue = (String)value0;
            boolean anyBeginning = sValue.startsWith("%");
            boolean anyEnd = sValue.endsWith("%");
            Pattern pValue = Pattern.compile((anyBeginning ? ".*" : "") + Pattern.quote(sValue.substring(anyBeginning ? 1 : 0, sValue.length() - (anyEnd ? 1 : 0))) + (anyEnd ? ".*" : ""), 34);
            return o -> o instanceof String && pValue.matcher((String)o).matches();
        }
        return ALWAYS_FALSE;
    }

    static {
        OPERATORS.put(ModelCriteriaBuilder.Operator.EQ, CriteriaOperator::eq);
        OPERATORS.put(ModelCriteriaBuilder.Operator.NE, CriteriaOperator::ne);
        OPERATORS.put(ModelCriteriaBuilder.Operator.EXISTS, CriteriaOperator::exists);
        OPERATORS.put(ModelCriteriaBuilder.Operator.NOT_EXISTS, CriteriaOperator::notExists);
        OPERATORS.put(ModelCriteriaBuilder.Operator.LT, CriteriaOperator::lt);
        OPERATORS.put(ModelCriteriaBuilder.Operator.LE, CriteriaOperator::le);
        OPERATORS.put(ModelCriteriaBuilder.Operator.GT, CriteriaOperator::gt);
        OPERATORS.put(ModelCriteriaBuilder.Operator.GE, CriteriaOperator::ge);
        OPERATORS.put(ModelCriteriaBuilder.Operator.IN, CriteriaOperator::in);
        OPERATORS.put(ModelCriteriaBuilder.Operator.LIKE, CriteriaOperator::like);
        OPERATORS.put(ModelCriteriaBuilder.Operator.ILIKE, CriteriaOperator::ilike);
        EnumSet<ModelCriteriaBuilder.Operator> s = EnumSet.allOf(ModelCriteriaBuilder.Operator.class);
        s.removeAll(OPERATORS.keySet());
        if (!s.isEmpty()) {
            throw new IllegalStateException("Some operators are not implemented: " + s);
        }
    }

    private static class ComparisonPredicateImpl
    implements Predicate<Object> {
        private final Op op;
        private final Comparable cValue;

        public ComparisonPredicateImpl(Op op, Comparable cValue) {
            this.op = op;
            this.cValue = cValue;
        }

        @Override
        public boolean test(Object o) {
            try {
                return o != null && this.op.isComparisonTrue(this.cValue.compareTo(o));
            }
            catch (ClassCastException ex) {
                LOG.log(Level.WARNING, "Incomparable argument type for comparison operation: {0}", this.cValue.getClass().getSimpleName());
                return false;
            }
        }

        private static enum Op {
            LT{

                @Override
                boolean isComparisonTrue(int compareToValue) {
                    return compareToValue > 0;
                }
            }
            ,
            LE{

                @Override
                boolean isComparisonTrue(int compareToValue) {
                    return compareToValue >= 0;
                }
            }
            ,
            GT{

                @Override
                boolean isComparisonTrue(int compareToValue) {
                    return compareToValue < 0;
                }
            }
            ,
            GE{

                @Override
                boolean isComparisonTrue(int compareToValue) {
                    return compareToValue <= 0;
                }
            };


            abstract boolean isComparisonTrue(int var1);
        }
    }
}

