/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common.delegate;

import java.util.Collection;
import java.util.Map;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.UpdatableEntity;

public interface EntityFieldDelegate<E>
extends UpdatableEntity {
    public Object get(EntityField<E> var1);

    default public <T> void set(EntityField<E> field, T value) {
    }

    default public <T> void collectionAdd(EntityField<E> field, T value) {
        Collection c = (Collection)this.get(field);
        if (c != null) {
            c.add(value);
        }
    }

    default public <T> Object collectionRemove(EntityField<E> field, T value) {
        Collection c = (Collection)this.get(field);
        return c == null ? null : Boolean.valueOf(c.remove(value));
    }

    default public <K> Object mapGet(EntityField<E> field, K key) {
        Map m = (Map)this.get(field);
        return m == null ? null : m.get(key);
    }

    default public <K, T> void mapPut(EntityField<E> field, K key, T value) {
        Map m = (Map)this.get(field);
        if (m != null) {
            m.put(key, value);
        }
    }

    default public <K> Object mapRemove(EntityField<E> field, K key) {
        Map m = (Map)this.get(field);
        if (m != null) {
            return m.remove(key);
        }
        return null;
    }
}

