/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityFields;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.common.delegate.DelegateProvider;

public class MapClientEntityDelegate
implements MapClientEntity {
    private final DelegateProvider<MapClientEntity> delegateProvider;

    public MapClientEntityDelegate(DelegateProvider<MapClientEntity> delegateProvider) {
        this.delegateProvider = delegateProvider;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.ATTRIBUTES).getAttributes();
    }

    @Override
    public void setAttributes(Map<String, List<String>> attributes) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.ATTRIBUTES).setAttributes(attributes);
    }

    @Override
    public List<String> getAttribute(String name) {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.ATTRIBUTES).getAttribute(name);
    }

    @Override
    public void setAttribute(String name, List<String> value) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.ATTRIBUTES).setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.ATTRIBUTES).removeAttribute(name);
    }

    @Override
    public boolean isUpdated() {
        return this.delegateProvider.isUpdated();
    }

    @Override
    public String getId() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.ID).getId();
    }

    @Override
    public void setId(String id) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.ID).setId(id);
    }

    @Override
    public Map<String, Boolean> getClientScopes() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.CLIENT_SCOPES).getClientScopes();
    }

    @Override
    public Stream<String> getClientScopes(boolean defaultScope) {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.CLIENT_SCOPES).getClientScopes(defaultScope);
    }

    @Override
    public void setClientScope(String id, Boolean defaultScope) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.CLIENT_SCOPES).setClientScope(id, defaultScope);
    }

    @Override
    public void removeClientScope(String id) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.CLIENT_SCOPES).removeClientScope(id);
    }

    @Override
    public MapProtocolMapperEntity getProtocolMapper(String id) {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.PROTOCOL_MAPPERS).getProtocolMapper(id);
    }

    @Override
    public Map<String, MapProtocolMapperEntity> getProtocolMappers() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.PROTOCOL_MAPPERS).getProtocolMappers();
    }

    @Override
    public void setProtocolMapper(String id, MapProtocolMapperEntity mapping) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.PROTOCOL_MAPPERS).setProtocolMapper(id, mapping);
    }

    @Override
    public void removeProtocolMapper(String id) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.PROTOCOL_MAPPERS).removeProtocolMapper(id);
    }

    @Override
    public void addRedirectUri(String redirectUri) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.REDIRECT_URIS).addRedirectUri(redirectUri);
    }

    @Override
    public Set<String> getRedirectUris() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.REDIRECT_URIS).getRedirectUris();
    }

    @Override
    public void removeRedirectUri(String redirectUri) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.REDIRECT_URIS).removeRedirectUri(redirectUri);
    }

    @Override
    public void setRedirectUris(Set<String> redirectUris) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.REDIRECT_URIS).setRedirectUris(redirectUris);
    }

    @Override
    public void addScopeMapping(String id) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.SCOPE_MAPPINGS).addScopeMapping(id);
    }

    @Override
    public void removeScopeMapping(String id) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.SCOPE_MAPPINGS).removeScopeMapping(id);
    }

    @Override
    public Collection<String> getScopeMappings() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.SCOPE_MAPPINGS).getScopeMappings();
    }

    @Override
    public void addWebOrigin(String webOrigin) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.WEB_ORIGINS).addWebOrigin(webOrigin);
    }

    @Override
    public Set<String> getWebOrigins() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.WEB_ORIGINS).getWebOrigins();
    }

    @Override
    public void removeWebOrigin(String webOrigin) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.WEB_ORIGINS).removeWebOrigin(webOrigin);
    }

    @Override
    public void setWebOrigins(Set<String> webOrigins) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.WEB_ORIGINS).setWebOrigins(webOrigins);
    }

    @Override
    public String getAuthenticationFlowBindingOverride(String binding) {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.AUTHENTICATION_FLOW_BINDING_OVERRIDES).getAuthenticationFlowBindingOverride(binding);
    }

    @Override
    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.AUTHENTICATION_FLOW_BINDING_OVERRIDES).getAuthenticationFlowBindingOverrides();
    }

    @Override
    public void removeAuthenticationFlowBindingOverride(String binding) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.AUTHENTICATION_FLOW_BINDING_OVERRIDES).removeAuthenticationFlowBindingOverride(binding);
    }

    @Override
    public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.AUTHENTICATION_FLOW_BINDING_OVERRIDES).setAuthenticationFlowBindingOverride(binding, flowId);
    }

    @Override
    public String getBaseUrl() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.BASE_URL).getBaseUrl();
    }

    @Override
    public String getClientAuthenticatorType() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.CLIENT_AUTHENTICATOR_TYPE).getClientAuthenticatorType();
    }

    @Override
    public String getClientId() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.CLIENT_ID).getClientId();
    }

    @Override
    public String getDescription() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.DESCRIPTION).getDescription();
    }

    @Override
    public String getManagementUrl() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.MANAGEMENT_URL).getManagementUrl();
    }

    @Override
    public String getName() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.NAME).getName();
    }

    @Override
    public Integer getNodeReRegistrationTimeout() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.NODE_RE_REGISTRATION_TIMEOUT).getNodeReRegistrationTimeout();
    }

    @Override
    public Integer getNotBefore() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.NOT_BEFORE).getNotBefore();
    }

    @Override
    public String getProtocol() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.PROTOCOL).getProtocol();
    }

    @Override
    public String getRealmId() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.REALM_ID).getRealmId();
    }

    @Override
    public String getRegistrationToken() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.REGISTRATION_TOKEN).getRegistrationToken();
    }

    @Override
    public String getRootUrl() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.ROOT_URL).getRootUrl();
    }

    @Override
    public Set<String> getScope() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.SCOPE).getScope();
    }

    @Override
    public String getSecret() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.SECRET).getSecret();
    }

    @Override
    public Boolean isAlwaysDisplayInConsole() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.ALWAYS_DISPLAY_IN_CONSOLE).isAlwaysDisplayInConsole();
    }

    @Override
    public Boolean isBearerOnly() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.BEARER_ONLY).isBearerOnly();
    }

    @Override
    public Boolean isConsentRequired() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.CONSENT_REQUIRED).isConsentRequired();
    }

    @Override
    public Boolean isDirectAccessGrantsEnabled() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.DIRECT_ACCESS_GRANTS_ENABLED).isDirectAccessGrantsEnabled();
    }

    @Override
    public Boolean isEnabled() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.ENABLED).isEnabled();
    }

    @Override
    public Boolean isFrontchannelLogout() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.FRONTCHANNEL_LOGOUT).isFrontchannelLogout();
    }

    @Override
    public Boolean isFullScopeAllowed() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.FULL_SCOPE_ALLOWED).isFullScopeAllowed();
    }

    @Override
    public Boolean isImplicitFlowEnabled() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.IMPLICIT_FLOW_ENABLED).isImplicitFlowEnabled();
    }

    @Override
    public Boolean isPublicClient() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.PUBLIC_CLIENT).isPublicClient();
    }

    @Override
    public Boolean isServiceAccountsEnabled() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.SERVICE_ACCOUNTS_ENABLED).isServiceAccountsEnabled();
    }

    @Override
    public Boolean isStandardFlowEnabled() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.STANDARD_FLOW_ENABLED).isStandardFlowEnabled();
    }

    @Override
    public Boolean isSurrogateAuthRequired() {
        return this.delegateProvider.getDelegate(true, (Object)MapClientEntityFields.SURROGATE_AUTH_REQUIRED).isSurrogateAuthRequired();
    }

    @Override
    public void setAlwaysDisplayInConsole(Boolean alwaysDisplayInConsole) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.ALWAYS_DISPLAY_IN_CONSOLE).setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.BASE_URL).setBaseUrl(baseUrl);
    }

    @Override
    public void setBearerOnly(Boolean bearerOnly) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.BEARER_ONLY).setBearerOnly(bearerOnly);
    }

    @Override
    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.CLIENT_AUTHENTICATOR_TYPE).setClientAuthenticatorType(clientAuthenticatorType);
    }

    @Override
    public void setClientId(String clientId) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.CLIENT_ID).setClientId(clientId);
    }

    @Override
    public void setConsentRequired(Boolean consentRequired) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.CONSENT_REQUIRED).setConsentRequired(consentRequired);
    }

    @Override
    public void setDescription(String description) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.DESCRIPTION).setDescription(description);
    }

    @Override
    public void setDirectAccessGrantsEnabled(Boolean directAccessGrantsEnabled) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.DIRECT_ACCESS_GRANTS_ENABLED).setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.ENABLED).setEnabled(enabled);
    }

    @Override
    public void setFrontchannelLogout(Boolean frontchannelLogout) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.FRONTCHANNEL_LOGOUT).setFrontchannelLogout(frontchannelLogout);
    }

    @Override
    public void setFullScopeAllowed(Boolean fullScopeAllowed) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.FULL_SCOPE_ALLOWED).setFullScopeAllowed(fullScopeAllowed);
    }

    @Override
    public void setImplicitFlowEnabled(Boolean implicitFlowEnabled) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.IMPLICIT_FLOW_ENABLED).setImplicitFlowEnabled(implicitFlowEnabled);
    }

    @Override
    public void setManagementUrl(String managementUrl) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.MANAGEMENT_URL).setManagementUrl(managementUrl);
    }

    @Override
    public void setName(String name) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.NAME).setName(name);
    }

    @Override
    public void setNodeReRegistrationTimeout(Integer nodeReRegistrationTimeout) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.NODE_RE_REGISTRATION_TIMEOUT).setNodeReRegistrationTimeout(nodeReRegistrationTimeout);
    }

    @Override
    public void setNotBefore(Integer notBefore) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.NOT_BEFORE).setNotBefore(notBefore);
    }

    @Override
    public void setProtocol(String protocol) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.PROTOCOL).setProtocol(protocol);
    }

    @Override
    public void setPublicClient(Boolean publicClient) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.PUBLIC_CLIENT).setPublicClient(publicClient);
    }

    @Override
    public void setRealmId(String realmId) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.REALM_ID).setRealmId(realmId);
    }

    @Override
    public void setRegistrationToken(String registrationToken) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.REGISTRATION_TOKEN).setRegistrationToken(registrationToken);
    }

    @Override
    public void setRootUrl(String rootUrl) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.ROOT_URL).setRootUrl(rootUrl);
    }

    @Override
    public void setScope(Set<String> scope) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.SCOPE).setScope(scope);
    }

    @Override
    public void setSecret(String secret) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.SECRET).setSecret(secret);
    }

    @Override
    public void setServiceAccountsEnabled(Boolean serviceAccountsEnabled) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.SERVICE_ACCOUNTS_ENABLED).setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    @Override
    public void setStandardFlowEnabled(Boolean standardFlowEnabled) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.STANDARD_FLOW_ENABLED).setStandardFlowEnabled(standardFlowEnabled);
    }

    @Override
    public void setSurrogateAuthRequired(Boolean surrogateAuthRequired) {
        this.delegateProvider.getDelegate(false, (Object)MapClientEntityFields.SURROGATE_AUTH_REQUIRED).setSurrogateAuthRequired(surrogateAuthRequired);
    }
}

