/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.EntityWithAttributes;
import org.keycloak.models.map.common.UpdatableEntity;

public class MapResourceEntity
extends UpdatableEntity.Impl
implements AbstractEntity,
EntityWithAttributes {
    private String id;
    private String name;
    private String displayName;
    private final Set<String> uris = new HashSet<String>();
    private String type;
    private String iconUri;
    private String owner;
    private boolean ownerManagedAccess;
    private String resourceServerId;
    private final Set<String> scopeIds = new HashSet<String>();
    private final Set<String> policyIds = new HashSet<String>();
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();

    public MapResourceEntity(String id) {
        this.id = id;
    }

    public MapResourceEntity() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (this.id != null) {
            throw new IllegalStateException("Id cannot be changed");
        }
        this.id = id;
        this.updated |= id != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.updated |= !Objects.equals(this.name, name);
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.updated |= !Objects.equals(this.displayName, displayName);
        this.displayName = displayName;
    }

    public Set<String> getUris() {
        return this.uris;
    }

    public void setUris(Set<String> uris) {
        if (Objects.equals(this.uris, uris)) {
            return;
        }
        this.updated = true;
        this.uris.clear();
        if (uris != null) {
            this.uris.addAll(uris);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.updated |= !Objects.equals(this.type, type);
        this.type = type;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.updated |= !Objects.equals(this.iconUri, iconUri);
        this.iconUri = iconUri;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.updated |= !Objects.equals(this.owner, owner);
        this.owner = owner;
    }

    public boolean isOwnerManagedAccess() {
        return this.ownerManagedAccess;
    }

    public void setOwnerManagedAccess(boolean ownerManagedAccess) {
        this.updated |= this.ownerManagedAccess != ownerManagedAccess;
        this.ownerManagedAccess = ownerManagedAccess;
    }

    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public void setResourceServerId(String resourceServerId) {
        this.updated |= !Objects.equals(this.resourceServerId, resourceServerId);
        this.resourceServerId = resourceServerId;
    }

    public Set<String> getScopeIds() {
        return this.scopeIds;
    }

    public void setScopeIds(Set<String> scopeIds) {
        if (Objects.equals(this.scopeIds, scopeIds)) {
            return;
        }
        this.updated = true;
        this.scopeIds.clear();
        if (scopeIds != null) {
            this.scopeIds.addAll(scopeIds);
        }
    }

    public Set<String> getPolicyIds() {
        return this.policyIds;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, List<String>> attributes) {
        this.updated |= !Objects.equals(this.attributes, attributes);
        this.attributes.clear();
        this.attributes.putAll(attributes);
    }

    @Override
    public List<String> getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, List<String> value) {
        this.updated |= !Objects.equals(this.attributes.put(name, value), value);
    }

    @Override
    public void removeAttribute(String name) {
        this.updated |= this.attributes.remove(name) != null;
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }
}

