/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class MapUserSessionProviderFactory<UK, CK>
implements AmphibianProviderFactory<UserSessionProvider>,
UserSessionProviderFactory,
ProviderEventListener,
EnvironmentDependentProviderFactory {
    public static final String CONFIG_STORAGE_USER_SESSIONS = "storage-user-sessions";
    public static final String CONFIG_STORAGE_CLIENT_SESSIONS = "storage-client-sessions";
    public static final String PROVIDER_ID = "map";
    private Config.Scope storageConfigScopeUserSessions;
    private Config.Scope storageConfigScopeClientSessions;
    private Runnable onClose;

    public String getId() {
        return PROVIDER_ID;
    }

    public void init(Config.Scope config) {
        this.storageConfigScopeUserSessions = config.scope(new String[]{CONFIG_STORAGE_USER_SESSIONS});
        this.storageConfigScopeClientSessions = config.scope(new String[]{CONFIG_STORAGE_CLIENT_SESSIONS});
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
        this.onClose = () -> factory.unregister((ProviderEventListener)this);
    }

    public void close() {
        super.close();
        this.onClose.run();
    }

    public void loadPersistentSessions(KeycloakSessionFactory sessionFactory, int maxErrors, int sessionsPerSegment) {
    }

    public MapUserSessionProvider create(KeycloakSession session) {
        MapStorageProviderFactory storageProviderFactoryUs = (MapStorageProviderFactory)KeycloakModelUtils.getComponentFactory((KeycloakSessionFactory)session.getKeycloakSessionFactory(), MapStorageProvider.class, (Config.Scope)this.storageConfigScopeUserSessions, (String)"mapStorage");
        MapStorageProvider factoryUs = (MapStorageProvider)storageProviderFactoryUs.create(session);
        MapStorage<MapUserSessionEntity, UserSessionModel> userSessionStore = factoryUs.getStorage(UserSessionModel.class, new MapStorageProviderFactory.Flag[0]);
        MapStorageProviderFactory storageProviderFactoryCs = (MapStorageProviderFactory)KeycloakModelUtils.getComponentFactory((KeycloakSessionFactory)session.getKeycloakSessionFactory(), MapStorageProvider.class, (Config.Scope)this.storageConfigScopeClientSessions, (String)"mapStorage");
        MapStorageProvider factoryCs = (MapStorageProvider)storageProviderFactoryCs.create(session);
        MapStorage<MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionStore = factoryCs.getStorage(AuthenticatedClientSessionModel.class, new MapStorageProviderFactory.Flag[0]);
        return new MapUserSessionProvider(session, userSessionStore, clientSessionStore);
    }

    public String getHelpText() {
        return "User session provider";
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof UserModel.UserRemovedEvent) {
            UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
            MapUserSessionProvider provider = this.create(userRemovedEvent.getKeycloakSession());
            provider.removeUserSessions(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
        }
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

