/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.Objects;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MapAuthenticationExecutionEntity
implements UpdatableEntity {
    private String id;
    private String authenticator;
    private String authenticatorConfig;
    private String flowId;
    private String parentFlowId;
    private AuthenticationExecutionModel.Requirement requirement;
    private Boolean autheticatorFlow = false;
    private Integer priority = 0;
    private boolean updated;

    private MapAuthenticationExecutionEntity() {
    }

    public static MapAuthenticationExecutionEntity fromModel(AuthenticationExecutionModel model) {
        if (model == null) {
            return null;
        }
        MapAuthenticationExecutionEntity entity = new MapAuthenticationExecutionEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAuthenticator(model.getAuthenticator());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        entity.setFlowId(model.getFlowId());
        entity.setParentFlowId(model.getParentFlow());
        entity.setRequirement(model.getRequirement());
        entity.setAutheticatorFlow(model.isAuthenticatorFlow());
        entity.setPriority(model.getPriority());
        return entity;
    }

    public static AuthenticationExecutionModel toModel(MapAuthenticationExecutionEntity entity) {
        if (entity == null) {
            return null;
        }
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(entity.getId());
        model.setAuthenticator(entity.getAuthenticator());
        model.setAuthenticatorConfig(entity.getAuthenticatorConfig());
        model.setFlowId(entity.getFlowId());
        model.setParentFlow(entity.getParentFlowId());
        model.setRequirement(entity.getRequirement());
        model.setAuthenticatorFlow(entity.isAutheticatorFlow().booleanValue());
        model.setPriority(entity.getPriority().intValue());
        return model;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.updated = !Objects.equals(this.id, id);
        this.id = id;
    }

    public String getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(String authenticator) {
        this.updated = !Objects.equals(this.authenticator, authenticator);
        this.authenticator = authenticator;
    }

    public String getAuthenticatorConfig() {
        return this.authenticatorConfig;
    }

    public void setAuthenticatorConfig(String authenticatorConfig) {
        this.updated = !Objects.equals(this.authenticatorConfig, authenticatorConfig);
        this.authenticatorConfig = authenticatorConfig;
    }

    public AuthenticationExecutionModel.Requirement getRequirement() {
        return this.requirement;
    }

    public void setRequirement(AuthenticationExecutionModel.Requirement requirement) {
        this.updated = !Objects.equals(this.requirement, requirement);
        this.requirement = requirement;
    }

    public Boolean isAutheticatorFlow() {
        return this.autheticatorFlow;
    }

    public void setAutheticatorFlow(boolean autheticatorFlow) {
        this.updated = !Objects.equals(this.requirement, this.requirement);
        this.autheticatorFlow = autheticatorFlow;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.updated = !Objects.equals(this.flowId, flowId);
        this.flowId = flowId;
    }

    public String getParentFlowId() {
        return this.parentFlowId;
    }

    public void setParentFlowId(String parentFlowId) {
        this.updated = !Objects.equals(this.parentFlowId, parentFlowId);
        this.parentFlowId = parentFlowId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.updated = !Objects.equals(this.priority, priority);
        this.priority = priority;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapAuthenticationExecutionEntity)) {
            return false;
        }
        MapAuthenticationExecutionEntity other = (MapAuthenticationExecutionEntity)obj;
        return Objects.equals(other.getId(), this.getId());
    }
}

