/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.StringKeyConvertor;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.chm.CriteriaOperator;
import org.keycloak.storage.SearchableModelField;

public class MapModelCriteriaBuilder<K, V extends AbstractEntity, M>
implements ModelCriteriaBuilder<M> {
    private static final Predicate<Object> ALWAYS_TRUE = e -> true;
    private static final Predicate<Object> ALWAYS_FALSE = e -> false;
    private final Predicate<? super K> keyFilter;
    private final Predicate<? super V> entityFilter;
    private final Map<SearchableModelField<M>, UpdatePredicatesFunc<K, V, M>> fieldPredicates;
    private final StringKeyConvertor<K> keyConvertor;

    public MapModelCriteriaBuilder(StringKeyConvertor<K> keyConvertor, Map<SearchableModelField<M>, UpdatePredicatesFunc<K, V, M>> fieldPredicates) {
        this(keyConvertor, fieldPredicates, ALWAYS_TRUE, ALWAYS_TRUE);
    }

    private MapModelCriteriaBuilder(StringKeyConvertor<K> keyConvertor, Map<SearchableModelField<M>, UpdatePredicatesFunc<K, V, M>> fieldPredicates, Predicate<? super K> indexReadFilter, Predicate<? super V> sequentialReadFilter) {
        this.keyConvertor = keyConvertor;
        this.fieldPredicates = fieldPredicates;
        this.keyFilter = indexReadFilter;
        this.entityFilter = sequentialReadFilter;
    }

    public MapModelCriteriaBuilder<K, V, M> compare(SearchableModelField<M> modelField, ModelCriteriaBuilder.Operator op, Object ... values) {
        UpdatePredicatesFunc<K, V, M> method = this.fieldPredicates.get(modelField);
        if (method == null) {
            throw new IllegalArgumentException("Filter not implemented for field " + modelField);
        }
        return method.apply(this, op, values);
    }

    @SafeVarargs
    public final MapModelCriteriaBuilder<K, V, M> and(ModelCriteriaBuilder<M> ... builders) {
        Predicate resIndexFilter = Stream.of(builders).map(MapModelCriteriaBuilder.class::cast).map(MapModelCriteriaBuilder::getKeyFilter).reduce(this.keyFilter, Predicate::and);
        Predicate resEntityFilter = Stream.of(builders).map(MapModelCriteriaBuilder.class::cast).map(MapModelCriteriaBuilder::getEntityFilter).reduce(this.entityFilter, Predicate::and);
        return new MapModelCriteriaBuilder<K, V, M>(this.keyConvertor, this.fieldPredicates, resIndexFilter, resEntityFilter);
    }

    @SafeVarargs
    public final MapModelCriteriaBuilder<K, V, M> or(ModelCriteriaBuilder<M> ... builders) {
        Predicate resIndexFilter = Stream.of(builders).map(MapModelCriteriaBuilder.class::cast).map(MapModelCriteriaBuilder::getKeyFilter).reduce(ALWAYS_FALSE, Predicate::or);
        Predicate resEntityFilter = Stream.of(builders).map(MapModelCriteriaBuilder.class::cast).map(MapModelCriteriaBuilder::getEntityFilter).reduce(ALWAYS_FALSE, Predicate::or);
        return new MapModelCriteriaBuilder<Object, AbstractEntity, M>(this.keyConvertor, this.fieldPredicates, v -> this.keyFilter.test(v) && resIndexFilter.test(v), v -> this.entityFilter.test(v) && resEntityFilter.test(v));
    }

    public MapModelCriteriaBuilder<K, V, M> not(ModelCriteriaBuilder<M> builder) {
        MapModelCriteriaBuilder b = builder.unwrap(MapModelCriteriaBuilder.class);
        if (b == null) {
            throw new ClassCastException("Incompatible class: " + builder.getClass());
        }
        Predicate<Object> resIndexFilter = b.getKeyFilter() == ALWAYS_TRUE ? ALWAYS_TRUE : b.getKeyFilter().negate();
        Predicate<Object> resEntityFilter = b.getEntityFilter() == ALWAYS_TRUE ? ALWAYS_TRUE : b.getEntityFilter().negate();
        return new MapModelCriteriaBuilder<Object, AbstractEntity, M>(this.keyConvertor, this.fieldPredicates, v -> this.keyFilter.test(v) && resIndexFilter.test(v), v -> this.entityFilter.test(v) && resEntityFilter.test(v));
    }

    public Predicate<? super K> getKeyFilter() {
        return this.keyFilter;
    }

    public Predicate<? super V> getEntityFilter() {
        return this.entityFilter;
    }

    protected MapModelCriteriaBuilder<K, V, M> idCompare(ModelCriteriaBuilder.Operator op, Object[] values) {
        Object[] convertedValues = this.convertValuesToKeyType(values);
        switch (op) {
            case LT: 
            case LE: 
            case GT: 
            case GE: 
            case EQ: 
            case NE: 
            case EXISTS: 
            case NOT_EXISTS: 
            case IN: {
                return new MapModelCriteriaBuilder<Object, V, M>(this.keyConvertor, this.fieldPredicates, this.keyFilter.and(CriteriaOperator.predicateFor(op, convertedValues)), this.entityFilter);
            }
        }
        throw new AssertionError((Object)("Invalid operator: " + (Object)((Object)op)));
    }

    protected Object[] convertValuesToKeyType(Object[] values) {
        if (values == null) {
            return null;
        }
        Object[] res = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (v instanceof String) {
                res[i] = this.keyConvertor.fromStringSafe((String)v);
                continue;
            }
            if (v instanceof Stream) {
                res[i] = ((Stream)v).map(o -> o instanceof String ? this.keyConvertor.fromStringSafe((String)o) : o);
                continue;
            }
            if (v instanceof Collection) {
                res[i] = ((List)v).stream().map(o -> o instanceof String ? this.keyConvertor.fromStringSafe((String)o) : o).collect(Collectors.toList());
                continue;
            }
            if (v == null) {
                res[i] = null;
                continue;
            }
            throw new IllegalArgumentException("Unknown type: " + v);
        }
        return res;
    }

    protected MapModelCriteriaBuilder<K, V, M> fieldCompare(ModelCriteriaBuilder.Operator op, Function<V, ?> getter, Object[] values) {
        Predicate<Object> valueComparator = CriteriaOperator.predicateFor(op, values);
        return this.fieldCompare(valueComparator, getter);
    }

    protected MapModelCriteriaBuilder<K, V, M> fieldCompare(Predicate<Object> valueComparator, Function<V, ?> getter) {
        Predicate<Object> resEntityFilter;
        if (this.entityFilter == ALWAYS_FALSE) {
            resEntityFilter = ALWAYS_FALSE;
        } else {
            Predicate<AbstractEntity> p = v -> valueComparator.test(getter.apply(v));
            resEntityFilter = p.and(this.entityFilter);
        }
        return new MapModelCriteriaBuilder<K, Object, M>(this.keyConvertor, this.fieldPredicates, this.keyFilter, resEntityFilter);
    }

    @FunctionalInterface
    public static interface UpdatePredicatesFunc<K, V extends AbstractEntity, M> {
        public MapModelCriteriaBuilder<K, V, M> apply(MapModelCriteriaBuilder<K, V, M> var1, ModelCriteriaBuilder.Operator var2, Object[] var3);
    }
}

