/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.StreamSerializer;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;

public class Serialization {
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).addMixIn(UpdatableEntity.class, IgnoreUpdatedMixIn.class).addMixIn(AbstractEntity.class, AbstractEntityMixIn.class);
    public static final ConcurrentHashMap<Class<?>, ObjectReader> READERS = new ConcurrentHashMap();
    public static final ConcurrentHashMap<Class<?>, ObjectWriter> WRITERS = new ConcurrentHashMap();

    public static <T extends AbstractEntity> T from(T orig) {
        return Serialization.from(orig, null);
    }

    public static <T extends AbstractEntity> T from(T orig, String newId) {
        if (orig == null) {
            return null;
        }
        Class<?> origClass = orig.getClass();
        try {
            ObjectReader reader = READERS.computeIfAbsent(origClass, arg_0 -> ((ObjectMapper)MAPPER).readerFor(arg_0));
            ObjectWriter writer = WRITERS.computeIfAbsent(origClass, arg_0 -> ((ObjectMapper)MAPPER).writerFor(arg_0));
            AbstractEntity res = (AbstractEntity)reader.readValue(writer.writeValueAsBytes(orig));
            if (newId != null) {
                Serialization.updateId(origClass, res, newId);
            }
            return (T)res;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static <K> void updateId(Class<?> origClass, AbstractEntity res, K newId) {
        Field field = Reflections.findDeclaredField(origClass, (String)"id");
        if (field == null) {
            throw new IllegalArgumentException("Cannot find id for " + origClass + " class");
        }
        try {
            ((Field)Reflections.setAccessible((AccessibleObject)field)).set(res, newId);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            Logger.getLogger(Serialization.class.getName()).log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Cannot set id for " + origClass + " class");
        }
    }

    static {
        JavaType type = TypeFactory.unknownType();
        JavaType streamType = MAPPER.getTypeFactory().constructParametricType(Stream.class, new JavaType[]{type});
        SimpleModule module = new SimpleModule().addSerializer((JsonSerializer)new StreamSerializer(streamType, type));
        MAPPER.registerModule((Module)module);
    }

    abstract class AbstractEntityMixIn {
        AbstractEntityMixIn() {
        }

        @JsonTypeInfo(property="id", use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.WRAPPER_ARRAY)
        abstract Object getId();
    }

    abstract class IgnoreUpdatedMixIn {
        IgnoreUpdatedMixIn() {
        }

        @JsonIgnore
        public abstract boolean isUpdated();
    }
}

