/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.map.client.MapClientEntity;

public class MapClientEntityLazyDelegate
implements MapClientEntity {
    private final Supplier<MapClientEntity> delegateSupplier;
    private final AtomicMarkableReference<MapClientEntity> delegate = new AtomicMarkableReference<Object>(null, false);

    public MapClientEntityLazyDelegate(Supplier<MapClientEntity> delegateSupplier) {
        this.delegateSupplier = delegateSupplier;
    }

    protected MapClientEntity getDelegate() {
        MapClientEntity ref;
        if (!this.delegate.isMarked()) {
            this.delegate.compareAndSet(null, this.delegateSupplier == null ? null : this.delegateSupplier.get(), false, true);
        }
        if ((ref = this.delegate.getReference()) == null) {
            throw new IllegalStateException("Invalid delegate obtained");
        }
        return ref;
    }

    @Override
    public void addClientScope(String id, Boolean defaultScope) {
        this.getDelegate().addClientScope(id, defaultScope);
    }

    @Override
    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        return this.getDelegate().addProtocolMapper(model);
    }

    @Override
    public void addRedirectUri(String redirectUri) {
        this.getDelegate().addRedirectUri(redirectUri);
    }

    @Override
    public void addScopeMapping(String id) {
        this.getDelegate().addScopeMapping(id);
    }

    @Override
    public void addWebOrigin(String webOrigin) {
        this.getDelegate().addWebOrigin(webOrigin);
    }

    @Override
    public void deleteScopeMapping(String id) {
        this.getDelegate().deleteScopeMapping(id);
    }

    @Override
    public List<String> getAttribute(String name) {
        return this.getDelegate().getAttribute(name);
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.getDelegate().getAttributes();
    }

    @Override
    public Map<String, String> getAuthFlowBindings() {
        return this.getDelegate().getAuthFlowBindings();
    }

    @Override
    public String getAuthenticationFlowBindingOverride(String binding) {
        return this.getDelegate().getAuthenticationFlowBindingOverride(binding);
    }

    @Override
    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return this.getDelegate().getAuthenticationFlowBindingOverrides();
    }

    @Override
    public String getBaseUrl() {
        return this.getDelegate().getBaseUrl();
    }

    @Override
    public String getClientAuthenticatorType() {
        return this.getDelegate().getClientAuthenticatorType();
    }

    @Override
    public String getClientId() {
        return this.getDelegate().getClientId();
    }

    @Override
    public Stream<String> getClientScopes(boolean defaultScope) {
        return this.getDelegate().getClientScopes(defaultScope);
    }

    @Override
    public String getDescription() {
        return this.getDelegate().getDescription();
    }

    @Override
    public String getManagementUrl() {
        return this.getDelegate().getManagementUrl();
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public int getNodeReRegistrationTimeout() {
        return this.getDelegate().getNodeReRegistrationTimeout();
    }

    @Override
    public int getNotBefore() {
        return this.getDelegate().getNotBefore();
    }

    @Override
    public String getProtocol() {
        return this.getDelegate().getProtocol();
    }

    @Override
    public ProtocolMapperModel getProtocolMapperById(String id) {
        return this.getDelegate().getProtocolMapperById(id);
    }

    @Override
    public Collection<ProtocolMapperModel> getProtocolMappers() {
        return this.getDelegate().getProtocolMappers();
    }

    @Override
    public String getRealmId() {
        return this.getDelegate().getRealmId();
    }

    @Override
    public Set<String> getRedirectUris() {
        return this.getDelegate().getRedirectUris();
    }

    @Override
    public String getRegistrationToken() {
        return this.getDelegate().getRegistrationToken();
    }

    @Override
    public String getRootUrl() {
        return this.getDelegate().getRootUrl();
    }

    @Override
    public Set<String> getScope() {
        return this.getDelegate().getScope();
    }

    @Override
    public Collection<String> getScopeMappings() {
        return this.getDelegate().getScopeMappings();
    }

    @Override
    public String getSecret() {
        return this.getDelegate().getSecret();
    }

    @Override
    public Set<String> getWebOrigins() {
        return this.getDelegate().getWebOrigins();
    }

    @Override
    public Boolean isAlwaysDisplayInConsole() {
        return this.getDelegate().isAlwaysDisplayInConsole();
    }

    @Override
    public Boolean isBearerOnly() {
        return this.getDelegate().isBearerOnly();
    }

    @Override
    public Boolean isConsentRequired() {
        return this.getDelegate().isConsentRequired();
    }

    @Override
    public Boolean isDirectAccessGrantsEnabled() {
        return this.getDelegate().isDirectAccessGrantsEnabled();
    }

    @Override
    public Boolean isEnabled() {
        return this.getDelegate().isEnabled();
    }

    @Override
    public Boolean isFrontchannelLogout() {
        return this.getDelegate().isFrontchannelLogout();
    }

    @Override
    public Boolean isFullScopeAllowed() {
        return this.getDelegate().isFullScopeAllowed();
    }

    @Override
    public Boolean isImplicitFlowEnabled() {
        return this.getDelegate().isImplicitFlowEnabled();
    }

    @Override
    public Boolean isPublicClient() {
        return this.getDelegate().isPublicClient();
    }

    @Override
    public Boolean isServiceAccountsEnabled() {
        return this.getDelegate().isServiceAccountsEnabled();
    }

    @Override
    public Boolean isStandardFlowEnabled() {
        return this.getDelegate().isStandardFlowEnabled();
    }

    @Override
    public Boolean isSurrogateAuthRequired() {
        return this.getDelegate().isSurrogateAuthRequired();
    }

    @Override
    public void removeAttribute(String name) {
        this.getDelegate().removeAttribute(name);
    }

    @Override
    public void removeAuthenticationFlowBindingOverride(String binding) {
        this.getDelegate().removeAuthenticationFlowBindingOverride(binding);
    }

    @Override
    public void removeClientScope(String id) {
        this.getDelegate().removeClientScope(id);
    }

    @Override
    public void removeProtocolMapper(String id) {
        this.getDelegate().removeProtocolMapper(id);
    }

    @Override
    public void removeRedirectUri(String redirectUri) {
        this.getDelegate().removeRedirectUri(redirectUri);
    }

    @Override
    public void removeWebOrigin(String webOrigin) {
        this.getDelegate().removeWebOrigin(webOrigin);
    }

    @Override
    public void setAlwaysDisplayInConsole(Boolean alwaysDisplayInConsole) {
        this.getDelegate().setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        this.getDelegate().setAttribute(name, values);
    }

    @Override
    public void setAuthFlowBindings(Map<String, String> authFlowBindings) {
        this.getDelegate().setAuthFlowBindings(authFlowBindings);
    }

    @Override
    public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        this.getDelegate().setAuthenticationFlowBindingOverride(binding, flowId);
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.getDelegate().setBaseUrl(baseUrl);
    }

    @Override
    public void setBearerOnly(Boolean bearerOnly) {
        this.getDelegate().setBearerOnly(bearerOnly);
    }

    @Override
    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.getDelegate().setClientAuthenticatorType(clientAuthenticatorType);
    }

    @Override
    public void setClientId(String clientId) {
        this.getDelegate().setClientId(clientId);
    }

    @Override
    public void setConsentRequired(Boolean consentRequired) {
        this.getDelegate().setConsentRequired(consentRequired);
    }

    @Override
    public void setDescription(String description) {
        this.getDelegate().setDescription(description);
    }

    @Override
    public void setDirectAccessGrantsEnabled(Boolean directAccessGrantsEnabled) {
        this.getDelegate().setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.getDelegate().setEnabled(enabled);
    }

    @Override
    public void setFrontchannelLogout(Boolean frontchannelLogout) {
        this.getDelegate().setFrontchannelLogout(frontchannelLogout);
    }

    @Override
    public void setFullScopeAllowed(Boolean fullScopeAllowed) {
        this.getDelegate().setFullScopeAllowed(fullScopeAllowed);
    }

    @Override
    public void setImplicitFlowEnabled(Boolean implicitFlowEnabled) {
        this.getDelegate().setImplicitFlowEnabled(implicitFlowEnabled);
    }

    @Override
    public void setManagementUrl(String managementUrl) {
        this.getDelegate().setManagementUrl(managementUrl);
    }

    @Override
    public void setName(String name) {
        this.getDelegate().setName(name);
    }

    @Override
    public void setNodeReRegistrationTimeout(int nodeReRegistrationTimeout) {
        this.getDelegate().setNodeReRegistrationTimeout(nodeReRegistrationTimeout);
    }

    @Override
    public void setNotBefore(int notBefore) {
        this.getDelegate().setNotBefore(notBefore);
    }

    @Override
    public void setProtocol(String protocol) {
        this.getDelegate().setProtocol(protocol);
    }

    @Override
    public void setProtocolMappers(Collection<ProtocolMapperModel> protocolMappers) {
        this.getDelegate().setProtocolMappers(protocolMappers);
    }

    @Override
    public void setPublicClient(Boolean publicClient) {
        this.getDelegate().setPublicClient(publicClient);
    }

    @Override
    public void setRedirectUris(Set<String> redirectUris) {
        this.getDelegate().setRedirectUris(redirectUris);
    }

    @Override
    public void setRegistrationToken(String registrationToken) {
        this.getDelegate().setRegistrationToken(registrationToken);
    }

    @Override
    public void setRootUrl(String rootUrl) {
        this.getDelegate().setRootUrl(rootUrl);
    }

    @Override
    public void setScope(Set<String> scope) {
        this.getDelegate().setScope(scope);
    }

    @Override
    public void setSecret(String secret) {
        this.getDelegate().setSecret(secret);
    }

    @Override
    public void setServiceAccountsEnabled(Boolean serviceAccountsEnabled) {
        this.getDelegate().setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    @Override
    public void setStandardFlowEnabled(Boolean standardFlowEnabled) {
        this.getDelegate().setStandardFlowEnabled(standardFlowEnabled);
    }

    @Override
    public void setSurrogateAuthRequired(Boolean surrogateAuthRequired) {
        this.getDelegate().setSurrogateAuthRequired(surrogateAuthRequired);
    }

    @Override
    public void setWebOrigins(Set<String> webOrigins) {
        this.getDelegate().setWebOrigins(webOrigins);
    }

    @Override
    public void updateProtocolMapper(String id, ProtocolMapperModel mapping) {
        this.getDelegate().updateProtocolMapper(id, mapping);
    }

    @Override
    public String getId() {
        return this.getDelegate().getId();
    }

    @Override
    public boolean isUpdated() {
        return this.getDelegate().isUpdated();
    }
}

