/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.entity;

import java.util.Objects;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;

public class MapResourceServerEntity
implements AbstractEntity,
UpdatableEntity {
    private final String id;
    private boolean updated = false;
    private boolean allowRemoteResourceManagement;
    private PolicyEnforcementMode policyEnforcementMode = PolicyEnforcementMode.ENFORCING;
    private DecisionStrategy decisionStrategy = DecisionStrategy.UNANIMOUS;

    public MapResourceServerEntity(String id) {
        this.id = id;
    }

    public MapResourceServerEntity() {
        this.id = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isAllowRemoteResourceManagement() {
        return this.allowRemoteResourceManagement;
    }

    public void setAllowRemoteResourceManagement(boolean allowRemoteResourceManagement) {
        this.updated |= this.allowRemoteResourceManagement != allowRemoteResourceManagement;
        this.allowRemoteResourceManagement = allowRemoteResourceManagement;
    }

    public PolicyEnforcementMode getPolicyEnforcementMode() {
        return this.policyEnforcementMode;
    }

    public void setPolicyEnforcementMode(PolicyEnforcementMode policyEnforcementMode) {
        this.updated |= !Objects.equals(this.policyEnforcementMode, policyEnforcementMode);
        this.policyEnforcementMode = policyEnforcementMode;
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.decisionStrategy;
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.updated |= !Objects.equals(this.decisionStrategy, decisionStrategy);
        this.decisionStrategy = decisionStrategy;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }
}

